/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.steps;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.ReflectionUtils;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.JavaParameterSet;
import nz.org.riskscape.engine.i18n.RiskscapeMessage;
import nz.org.riskscape.engine.i18n.RiskscapeMessageUtils;
import nz.org.riskscape.engine.pipeline.RealizationInput;
import nz.org.riskscape.engine.pipeline.Realized;
import nz.org.riskscape.engine.pipeline.RealizedPipeline;
import nz.org.riskscape.engine.pipeline.RealizedStep;
import nz.org.riskscape.engine.pipeline.Step;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.engine.steps.Input;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ResultOrProblems;

public abstract class BaseStep<T>
implements Step {
    private final JavaParameterSet<T> parameterSet = JavaParameterSet.fromBindingClass(this.findParameterClass(this.getClass()));
    private final Engine engine;
    private final Range<Integer> inputArity;
    private final List<String> inputNames;

    public BaseStep(Engine engine) {
        this.engine = engine;
        this.inputArity = this.buildArity();
        this.inputNames = this.buildInputNames();
    }

    public String getId() {
        if (this.getClass().getPackage().getName().equals("nz.org.riskscape.engine.steps")) {
            String truncated = this.getClass().getSimpleName().replace("Step", "");
            return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, truncated);
        }
        return this.getClass().getName();
    }

    public RiskscapeMessage getDescription() {
        return RiskscapeMessageUtils.forFieldWithDefault((String)"description", this.getClass(), (String)"N/A");
    }

    public final Range<Integer> getInputArity() {
        return this.inputArity;
    }

    public RealizedPipeline realize(RealizationInput input) {
        ResultOrProblems realizedOr = this.buildParametersObject(input).flatMap(paramsObj -> this.realize(paramsObj));
        RealizedStep newStep = input.newPrototypeStep().realizedBy((Step)this).withResult(realizedOr);
        return input.getRealizedPipeline().add(newStep);
    }

    protected ResultOrProblems<T> buildParametersObject(RealizationInput input) {
        return this.bindParameters(input).flatMap(paramsObj -> this.bindInputs(paramsObj, input.getDependencies())).map(paramsObj -> {
            this.bindRealizationInput(input, paramsObj);
            return paramsObj;
        });
    }

    public ResultOrProblems<? extends Realized> realizeSimple(RealizationInput input) {
        RealizedPipeline newPipeline = this.realize(input);
        RealizedPipeline prevPipeline = input.getRealizedPipeline();
        Sets.SetView difference = Sets.difference(Set.copyOf(newPipeline.getRealizedSteps()), Set.copyOf(prevPipeline.getRealizedSteps()));
        assert (difference.size() == 1) : "New pipeline added more than one new step - " + String.valueOf(difference);
        return ((RealizedStep)difference.iterator().next()).getResult();
    }

    private Range<Integer> buildArity() {
        return Range.singleton((Comparable)Integer.valueOf(ReflectionUtils.getAnnotatedFields(this.findParameterClass(this.getClass()), Input.class).size()));
    }

    private List<String> buildInputNames() {
        if ((Integer)this.buildArity().upperEndpoint() <= 1) {
            return Collections.emptyList();
        }
        return ReflectionUtils.getAnnotatedFields(this.findParameterClass(this.getClass()), Input.class).stream().map(i -> CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, i.getName())).collect(Collectors.toList());
    }

    public abstract ResultOrProblems<? extends Realized> realize(T var1);

    protected ResultOrProblems<T> bindInputs(T parameters, List<RealizedStep> inputs) {
        List fields = ReflectionUtils.getAnnotatedFields(parameters.getClass(), Input.class);
        if (!this.getInputArity().contains((Comparable)Integer.valueOf(inputs.size()))) {
            return ResultOrProblems.failed((Problem[])new Problem[]{GeneralProblems.get().badArity(Input.class, (Object)this, this.getInputArity(), inputs.size())});
        }
        for (int idx = 0; idx < fields.size(); ++idx) {
            Field field = (Field)fields.get(idx);
            RealizedStep step = inputs.get(idx);
            try {
                field.set(parameters, step);
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RiskscapeException("Unable to set field " + String.valueOf(field) + " with value " + String.valueOf(step), (Throwable)e);
            }
        }
        return ResultOrProblems.of(parameters);
    }

    protected Class<T> findParameterClass(Class<?> modelClass) {
        ParameterizedType genericSuperclass;
        try {
            genericSuperclass = (ParameterizedType)modelClass.getGenericSuperclass();
        }
        catch (ClassCastException e) {
            throw new RuntimeException("BaseModel classes must declare a generic type: " + String.valueOf(modelClass), e);
        }
        try {
            return (Class)genericSuperclass.getActualTypeArguments()[0];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new RuntimeException("BaseModel classes must declare a generic type: " + String.valueOf(modelClass), ex);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof BaseStep) {
            return ((BaseStep)obj).getId().equals(this.getId());
        }
        return false;
    }

    protected ResultOrProblems<T> bindParameters(RealizationInput input) {
        BindingContext bindingContext = input.getExecutionContext().getBindingContext();
        Map paramMap = input.getParameters();
        return this.parameterSet.bindToObject(bindingContext, paramMap).map(bound -> bound.getBoundToObject());
    }

    private void bindRealizationInput(RealizationInput input, T instance) {
        for (Class<?> ptr = instance.getClass(); ptr != Object.class; ptr = ptr.getSuperclass()) {
            Field[] fields = instance.getClass().getFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (!field.getType().equals(RealizationInput.class)) continue;
                try {
                    field.set(instance, input);
                    continue;
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new RiskscapeException("Could not set raw input field " + String.valueOf(field), (Throwable)e);
                }
            }
        }
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    public String toString() {
        return this.getId();
    }

    protected Object getParamContext(String name) {
        return this.parameterSet.get(name);
    }

    @Generated
    public BaseStep(Engine engine, Range<Integer> inputArity, List<String> inputNames) {
        this.engine = engine;
        this.inputArity = inputArity;
        this.inputNames = inputNames;
    }

    @Generated
    public JavaParameterSet<T> getParameterSet() {
        return this.parameterSet;
    }

    @Generated
    public Engine getEngine() {
        return this.engine;
    }

    @Generated
    public List<String> getInputNames() {
        return this.inputNames;
    }
}

