/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.steps;

import java.util.Optional;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.bind.ParameterField;
import nz.org.riskscape.engine.output.PipelineJobContext;
import nz.org.riskscape.engine.pipeline.Realized;
import nz.org.riskscape.engine.pipeline.Sink;
import nz.org.riskscape.engine.pipeline.SinkConstructor;
import nz.org.riskscape.engine.pipeline.TupleInput;
import nz.org.riskscape.engine.projection.AsyncProjector;
import nz.org.riskscape.engine.projection.Projector;
import nz.org.riskscape.engine.projection.SelectProjector;
import nz.org.riskscape.engine.steps.BaseStep;
import nz.org.riskscape.engine.steps.ProjectionStep;
import nz.org.riskscape.engine.steps.SelectStep;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.Expression;

public class AsyncSelectStep
extends BaseStep<SelectStep.Parameters> {
    public AsyncSelectStep(Engine engine) {
        super(engine);
    }

    @Override
    public ResultOrProblems<? extends Realized> realize(SelectStep.Parameters parameters) {
        return SelectProjector.realize(parameters.input.getProduces(), parameters.select, parameters.rInput.getExecutionContext().getExpressionRealizer()).map(this::buildAsyncProjector);
    }

    private AsyncProjector buildAsyncProjector(final Projector projector) {
        final LinkedBlockingQueue queue = new LinkedBlockingQueue(10);
        final AtomicBoolean finished = new AtomicBoolean(false);
        return new AsyncProjector(){

            public Struct getProducedType() {
                return projector.getProducedType();
            }

            public SinkConstructor getOutput() {
                return new SinkConstructor(){

                    public ResultOrProblems<Sink> newInstance(PipelineJobContext context) {
                        return ResultOrProblems.of((Object)new Sink(){

                            public void finish() {
                                finished.set(true);
                            }

                            public boolean accept(Tuple tuple) {
                                return queue.offer(tuple);
                            }
                        });
                    }
                };
            }

            public TupleInput getInput() {
                return new TupleInput(){

                    public Struct getProducedType() {
                        return projector.getProducedType();
                    }

                    public Tuple poll() {
                        return (Tuple)queue.poll();
                    }

                    public boolean isComplete() {
                        return finished.get();
                    }

                    public boolean isAsync() {
                        return false;
                    }

                    public Optional<Long> size() {
                        return Optional.empty();
                    }
                };
            }
        };
    }

    public static class Parameters
    extends ProjectionStep.ProjectionParameters {
        @ParameterField
        Expression select;
    }
}

