/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.sort;

import java.util.ArrayList;
import java.util.Comparator;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.rl.ExpressionRealizer;
import nz.org.riskscape.engine.sort.SortBy;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemCode;
import nz.org.riskscape.problem.ResultOrProblems;

public class TupleComparator {
    public static final Comparator<Tuple> NONE = (l, r) -> 0;

    public static ResultOrProblems<Comparator<Tuple>> createComparator(Struct targetType, SortBy sortBy, ExpressionRealizer expressionRealizer) {
        ArrayList problems = new ArrayList();
        Comparator comparator = NONE;
        SortBy next = sortBy;
        while (!next.equals((Object)SortBy.NONE)) {
            ResultOrProblems<Comparator<Tuple>> nextComparator = TupleComparator.comparing(next, targetType, expressionRealizer);
            if (nextComparator.isPresent()) {
                comparator = comparator == NONE ? (Comparator)nextComparator.get() : comparator.thenComparing((Comparator)nextComparator.get());
            }
            problems.addAll(nextComparator.getProblems());
            next = next.getNext();
        }
        if (Problem.hasErrors(problems)) {
            return ResultOrProblems.failed(problems);
        }
        return ResultOrProblems.ofNullable(comparator, problems);
    }

    private static ResultOrProblems<Comparator<Tuple>> comparing(SortBy comparison, Struct tupleType, ExpressionRealizer expressionRealizer) {
        return expressionRealizer.realize((Type)tupleType, comparison.getExpr()).flatMap(realizedExpression -> {
            Type comparedType = Nullable.unwrap((Type)realizedExpression.getResultType());
            if (!TupleComparator.isComparable(comparedType, true)) {
                return ResultOrProblems.failed((Problem[])new Problem[]{Problem.error((ProblemCode)ProblemCodes.EXPRESSION_RESULT_NOT_COMPARABLE, (Object[])new Object[]{realizedExpression.getExpression().toSource(), comparedType})});
            }
            Comparator newComparator = (t1, t2) -> {
                Type nullableType = Nullable.of((Type)comparedType);
                Object lhs = nullableType.coerce(realizedExpression.evaluate(t1));
                Object rhs = nullableType.coerce(realizedExpression.evaluate(t2));
                return TupleComparator.stableCompareTo(lhs, rhs);
            };
            if (comparison.getDirection() == SortBy.Direction.DESC) {
                newComparator = newComparator.reversed();
            }
            return ResultOrProblems.of((Object)newComparator);
        });
    }

    private static boolean isComparable(Type toCompare, boolean allowTuples) {
        if (allowTuples && toCompare instanceof Struct) {
            Struct asStruct = (Struct)toCompare;
            for (Struct.StructMember member : asStruct.getMembers()) {
                if (TupleComparator.isComparable(Nullable.strip((Type)member.getType()), false)) continue;
                return false;
            }
            return true;
        }
        return Comparable.class.isAssignableFrom(toCompare.internalType());
    }

    private static int stableCompareTo(Object lhs, Object rhs) {
        if (lhs == null || rhs == null) {
            if (lhs == null && rhs == null) {
                return 0;
            }
            if (lhs == null) {
                return -1;
            }
            return 1;
        }
        if (lhs instanceof Comparable) {
            return ((Comparable)lhs).compareTo(rhs);
        }
        if (lhs instanceof Tuple) {
            int signum = 0;
            Tuple lhsTuple = (Tuple)lhs;
            Tuple rhsTuple = (Tuple)rhs;
            for (Struct.StructMember member : lhsTuple.getStruct().getMembers()) {
                Object rhsMember;
                Object lhsMember = lhsTuple.fetch(member);
                signum = TupleComparator.stableCompareTo(lhsMember, rhsMember = rhsTuple.fetch(member));
                if (signum == 0) continue;
                return signum;
            }
            return signum;
        }
        throw new IllegalArgumentException("Can not cast to comparable or tuple " + String.valueOf(lhs.getClass()));
    }

    public static enum ProblemCodes implements ProblemCode
    {
        EXPRESSION_RESULT_NOT_COMPARABLE;

    }
}

