/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.sort;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.io.TupleReader;
import nz.org.riskscape.engine.relation.TupleIterator;
import nz.org.riskscape.engine.types.Struct;

public class MergeSortIterator
implements TupleIterator {
    private final List<TupleReader> readers;
    private final boolean[] finished;
    private final Tuple[] peeked;
    private final Comparator<Tuple> comparator;
    private final Struct type;
    private Runnable onClose;

    public MergeSortIterator(Comparator<Tuple> comparator, Struct type, List<TupleReader> readers, Runnable onClose) {
        this.type = type;
        this.readers = readers;
        this.peeked = new Tuple[readers.size()];
        this.finished = new boolean[readers.size()];
        this.comparator = comparator;
        this.onClose = onClose;
    }

    public boolean hasNext() {
        this.fillPeeks();
        for (boolean finit : this.finished) {
            if (finit) continue;
            return true;
        }
        return false;
    }

    public Tuple next() {
        this.fillPeeks();
        int minIndex = -1;
        Tuple min = null;
        for (int i = 0; i < this.finished.length; ++i) {
            if (this.finished[i]) continue;
            Tuple cmp = this.peeked[i];
            if (min != null && this.comparator.compare(min, cmp) <= 0) continue;
            min = cmp;
            minIndex = i;
        }
        this.peeked[minIndex] = null;
        return min;
    }

    public void close() {
        this.onClose.run();
    }

    private void fillPeeks() {
        for (int i = 0; i < this.finished.length; ++i) {
            Tuple read;
            if (this.finished[i] || this.peeked[i] != null) continue;
            try {
                read = this.readers.get(i).read(this.type);
            }
            catch (IOException e) {
                throw new RuntimeException("Underlying reader threw an exception", e);
            }
            if (read == null) {
                this.finished[i] = true;
                continue;
            }
            this.peeked[i] = read;
        }
    }
}

