/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.sched;

import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import nz.org.riskscape.engine.sched.Scheduler;
import nz.org.riskscape.engine.task.ReturnState;
import nz.org.riskscape.engine.task.WorkerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Worker
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Worker.class);
    public final AtomicReference<Result> lastResult = new AtomicReference();
    private final int id;
    public final Scheduler owner;
    private WorkerTask currentTask;
    private final Object sleepMutex = new Object();
    private boolean threadActive = true;
    public static final int MAX_WAIT_MILLISECS = 1000;

    public boolean isRunning() {
        return this.hasCurrentTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasCurrentTask() {
        Object object = this.sleepMutex;
        synchronized (object) {
            return this.currentTask != null;
        }
    }

    public Result clearLastTask() {
        return this.lastResult.getAndSet(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeThread() {
        Object object = this.sleepMutex;
        synchronized (object) {
            this.sleepMutex.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentTask(WorkerTask task) {
        Object object = this.sleepMutex;
        synchronized (object) {
            this.currentTask = task;
        }
    }

    public void runTask(WorkerTask toRun) {
        this.setCurrentTask(toRun);
        this.wakeThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForMoreWork() {
        Object object = this.sleepMutex;
        synchronized (object) {
            if (this.currentTask == null) {
                try {
                    this.sleepMutex.wait(1000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Worker interupted", e);
                }
            }
        }
    }

    @Override
    public void run() {
        while (this.threadActive) {
            this.waitForMoreWork();
            if (!this.hasCurrentTask()) continue;
            try {
                ReturnState result = this.currentTask.runPublic();
                this.storeResult(result);
            }
            catch (Throwable t) {
                this.storeException(t);
            }
            this.setCurrentTask(null);
            this.owner.workerFinished();
        }
    }

    private void storeResult(ReturnState result) {
        this.lastResult.set(new Result(this.currentTask, result));
    }

    private void storeException(Throwable t) {
        log.info("Exception processing {}: {}", (Object)this.currentTask, (Object)t);
        this.lastResult.set(new Result(this.currentTask, ReturnState.ERROR_THROWN, t));
    }

    public void stop() {
        this.threadActive = false;
        this.wakeThread();
    }

    public String toString() {
        return String.format("Worker thread #%d", this.id);
    }

    @Generated
    public Worker(int id, Scheduler owner) {
        this.id = id;
        this.owner = owner;
    }

    public class Result {
        public final WorkerTask task;
        public final ReturnState state;
        public final Throwable errorThrown;

        public Result(WorkerTask task, ReturnState state) {
            this(task, state, null);
        }

        @Generated
        public Result(WorkerTask task, ReturnState state, Throwable errorThrown) {
            this.task = task;
            this.state = state;
            this.errorThrown = errorThrown;
        }
    }
}

