/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.sched;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.config.BootstrapIniSettings;

class SchedulerParams {
    public static final String PAGE_SIZE_SETTING = "engine.page-size";
    public static final String TUPLES_PER_TASK_SETTING = "engine.tuples-per-task";
    public static final List<String> SETTINGS_KEYS = Arrays.asList("engine.page-size", "engine.tuples-per-task");
    public static final int DEFAULT_MAX_TUPLES_QUEUED = 16384;
    private int maxTuplesQueued = 16384;
    private Optional<Integer> pageSize;
    private Optional<Integer> tuplesPerTask;
    private final int numThreads;

    SchedulerParams(int numThreads) {
        this(numThreads, BootstrapIniSettings.NONE);
    }

    SchedulerParams(int numThreads, BootstrapIniSettings settings) {
        this.numThreads = numThreads;
        int config = settings.getOrDefault(PAGE_SIZE_SETTING, 0);
        this.pageSize = Optional.ofNullable(config > 0 ? Integer.valueOf(config) : null);
        config = settings.getOrDefault(TUPLES_PER_TASK_SETTING, 0);
        this.tuplesPerTask = Optional.ofNullable(config > 0 ? Integer.valueOf(config) : null);
    }

    int getMaxThreadsPerTask() {
        return this.numThreads;
    }

    @Generated
    int getMaxTuplesQueued() {
        return this.maxTuplesQueued;
    }

    @Generated
    Optional<Integer> getPageSize() {
        return this.pageSize;
    }

    @Generated
    Optional<Integer> getTuplesPerTask() {
        return this.tuplesPerTask;
    }

    @Generated
    int getNumThreads() {
        return this.numThreads;
    }
}

