/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.sched;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import nz.org.riskscape.config.BootstrapIniSettings;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.output.PipelineJobContext;
import nz.org.riskscape.engine.pipeline.DefaultPipelineExecutor;
import nz.org.riskscape.engine.pipeline.ExecutionResult;
import nz.org.riskscape.engine.sched.Scheduler;
import nz.org.riskscape.engine.sched.SchedulerParams;
import nz.org.riskscape.engine.util.Pair;

public class SchedulerBasedExecutor
extends DefaultPipelineExecutor {
    private Scheduler scheduler;

    public SchedulerBasedExecutor(Engine engine) {
        super(engine);
    }

    private synchronized Scheduler getScheduler() {
        if (this.scheduler == null) {
            this.scheduler = new Scheduler(this.getSchedulerParams(), this.engine.getProblemSink());
        }
        return this.scheduler;
    }

    private SchedulerParams getSchedulerParams() {
        Map<String, List<String>> schedulerSettings = SchedulerParams.SETTINGS_KEYS.stream().map(key -> Pair.of((Object)key, (Object)this.engine.getSetting(key))).filter(pair -> !((List)pair.getRight()).isEmpty()).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
        return new SchedulerParams(this.getNumThreads(), new BootstrapIniSettings(schedulerSettings, this.engine.getProblemSink()));
    }

    public Future<ExecutionResult> execute(PipelineJobContext jobContext) {
        return this.getScheduler().queueJob(jobContext);
    }
}

