/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.sched;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metered;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.output.PipelineJobContext;
import nz.org.riskscape.engine.pipeline.ExecutionResult;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.sched.ExecutionFuture;
import nz.org.riskscape.engine.sched.SchedulerParams;
import nz.org.riskscape.engine.sched.TaskBuilder;
import nz.org.riskscape.engine.sched.Worker;
import nz.org.riskscape.engine.task.ReturnState;
import nz.org.riskscape.engine.task.TaskSpec;
import nz.org.riskscape.engine.task.TaskState;
import nz.org.riskscape.engine.task.WorkerTask;
import nz.org.riskscape.engine.task.WritePageBuffer;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.ProblemSink;
import nz.org.riskscape.problem.Problems;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scheduler
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Scheduler.class);
    private static final WorkerTask NO_TASKS_WAITING = new WorkerTask(){

        @Override
        public ReturnState run() {
            return null;
        }

        @Override
        public boolean producesResult() {
            return false;
        }
    };
    private static final WorkerTask NO_TASKS_READY = new WorkerTask(){

        @Override
        public ReturnState run() {
            return null;
        }

        @Override
        public boolean producesResult() {
            return false;
        }
    };
    public static final int MAX_WAIT_MILLISECS = 100;
    private List<Worker> workers = new ArrayList<Worker>();
    private List<Thread> workerThreads = new ArrayList<Thread>();
    private List<WorkerTask> waitingTasks = new ArrayList<WorkerTask>();
    private List<WorkerTask> runningTasks = new ArrayList<WorkerTask>();
    private List<WorkerTask> completedTasks = new ArrayList<WorkerTask>();
    private Object sleepMutex = new Object();
    private final ProblemSink problemSink;
    private final Thread schedulerThread = new Thread((Runnable)this, "scheduler-thread");
    private boolean stopped = false;
    boolean detectDeadlocks = true;
    private boolean workerFinished = false;
    private boolean taskProducedNoData = true;
    private final SchedulerParams params;
    private LinkedList<ExecutionFuture> jobQueue = new LinkedList();
    private ExecutionFuture currentJob;

    public Scheduler(SchedulerParams params, ProblemSink problemSink) {
        this.params = params;
        this.problemSink = problemSink;
        for (int id = 1; id <= params.getNumThreads(); ++id) {
            Worker worker = new Worker(id, this);
            this.workers.add(worker);
            Thread thread = new Thread(worker);
            thread.setDaemon(true);
            thread.setName(String.format("execution-worker-%d", id));
            this.workerThreads.add(thread);
        }
    }

    void startWorkers() {
        this.workerThreads.forEach(Thread::start);
    }

    private void stopWorkers() {
        this.workers.forEach(Worker::stop);
    }

    private void checkForDeadlock(WorkerTask nextTask, long numWorkersRunning) {
        if (this.detectDeadlocks && nextTask == NO_TASKS_READY && numWorkersRunning == 0L) {
            log.error("Deadlock detected!  No worker threads are running and all tasks are blocked");
            HashMap<TaskSpec, List> blockedOnFullOutput = new HashMap<TaskSpec, List>();
            HashMap<TaskSpec, List> blockedOnDependencies = new HashMap<TaskSpec, List>();
            HashMap<TaskSpec, List> blockedOnNoInput = new HashMap<TaskSpec, List>();
            for (WorkerTask task : this.waitingTasks) {
                if (task.getPageWriter().map(pr -> pr.isFull()).orElse(false).booleanValue()) {
                    blockedOnFullOutput.computeIfAbsent(task.getSpec(), k -> new ArrayList()).add(task);
                }
                if (task.getSpec().hasOutstandingDependencies()) {
                    blockedOnDependencies.computeIfAbsent(task.getSpec(), k -> new ArrayList()).add(task);
                }
                if (!task.getPageReader().map(pr -> pr.getPagesRead() != 0L && !pr.hasInput()).orElse(false).booleanValue()) continue;
                blockedOnNoInput.computeIfAbsent(task.getSpec(), k -> new ArrayList()).add(task);
            }
            if (!blockedOnFullOutput.isEmpty()) {
                log.warn("  Blocked on full output:");
                blockedOnFullOutput.forEach((spec, tasks) -> log.warn("    {}", spec));
            }
            if (!blockedOnDependencies.isEmpty()) {
                log.warn("  Blocked on dependencies:");
                blockedOnDependencies.forEach((spec, tasks) -> log.warn("    {} - depending on {}", spec, spec.getDependsOn()));
            }
            if (!blockedOnNoInput.isEmpty()) {
                log.warn("  Blocked on no input:");
                blockedOnNoInput.forEach((spec, tasks) -> log.warn("    {} - {} / {} tasks blocked", new Object[]{spec, tasks.size(), spec.getWorkerTasks().size()}));
            }
            if (!this.completedTasks.isEmpty()) {
                log.warn("  Completed Tasks:");
                this.completedTasks.stream().map(WorkerTask::getSpec).collect(Collectors.toSet()).forEach(spec -> log.warn("    {}", spec));
            }
            throw new RiskscapeException((Problems)LocalProblems.get().deadlock());
        }
    }

    long numWorkersRunning() {
        return this.workers.stream().filter(p -> p.isRunning()).count();
    }

    boolean runOnce() {
        long numWorkersRunning = this.numWorkersRunning();
        if (numWorkersRunning == (long)this.workers.size()) {
            return false;
        }
        this.processWorkerResults();
        WorkerTask toRun = this.findNextTask();
        if (toRun == NO_TASKS_WAITING || toRun == NO_TASKS_READY) {
            this.checkForDeadlock(toRun, numWorkersRunning);
            return false;
        }
        Worker worker = this.findFreeWorker(toRun);
        if (worker == null) {
            log.error("Only {}/{} workers running, but scheduler couldn't find free worker", (Object)numWorkersRunning, (Object)this.workers.size());
            return false;
        }
        this.waitingTasks.remove(toRun);
        this.runningTasks.add(toRun);
        toRun.markStarted();
        this.ensureSpecIsStarted(toRun);
        log.debug("Running task {} on {}", (Object)toRun, (Object)worker);
        worker.runTask(toRun);
        return true;
    }

    private void ensureSpecIsStarted(WorkerTask task) {
        TaskSpec spec = task.getSpec();
        if (spec.isCreated()) {
            spec.changeState(TaskState.STARTED);
            MetricRegistry registry = spec.getExecutionContext().getMetricRegistry();
            for (Map.Entry<String, Metric> metricEntry : spec.getMetrics().entrySet()) {
                String name = task.getSpecNameBrief() + "." + metricEntry.getKey();
                registry.register(name, metricEntry.getValue());
            }
            for (Map.Entry<String, Metric> keyMetric : spec.getProgressMetrics().entrySet()) {
                spec.getJobContext().getProgressMetrics().register(task.getSpecNameBrief() + "." + keyMetric.getKey(), keyMetric.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.startWorkers();
            while (!this.stopped) {
                ExecutionFuture jobToProcess;
                boolean busy = this.runOnce();
                Object object = this.sleepMutex;
                synchronized (object) {
                    boolean bl = busy = busy || !this.jobQueue.isEmpty();
                    if (!busy) {
                        this.waitForNotify();
                    }
                }
                if (this.currentJob != null && this.allTasksComplete() && this.currentJob != null) {
                    this.currentJob.markComplete();
                    this.cleanupCurrentJob();
                }
                if (this.currentJob != null) continue;
                Object object2 = this.sleepMutex;
                synchronized (object2) {
                    jobToProcess = this.jobQueue.isEmpty() ? null : this.jobQueue.removeFirst();
                }
                if (jobToProcess == null) continue;
                this.prepareNextJob(jobToProcess);
            }
            this.stopWorkers();
        }
        catch (Throwable e) {
            log.error("Unhandled exception in scheduler, exiting thread loop!", e);
            if (this.currentJob != null) {
                this.currentJob.markFailed(LocalProblems.get().crash(e.getMessage()).withException(e));
                this.currentJob = null;
            }
            this.stop(true);
        }
    }

    private List<TaskSpec> buildTasks(ExecutionFuture queuedJob) {
        return new TaskBuilder(this.params).convertToTasks(queuedJob.getJobContext());
    }

    public boolean allTasksComplete() {
        return this.waitingTasks.isEmpty() && this.runningTasks.isEmpty() && this.completedTasks.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean join) {
        ArrayList<ExecutionFuture> toFail;
        Iterator iterator = this.sleepMutex;
        synchronized (iterator) {
            this.stopped = true;
            toFail = new ArrayList<ExecutionFuture>(this.jobQueue.size());
            toFail.addAll(this.jobQueue);
            this.jobQueue.clear();
            this.sleepMutex.notify();
        }
        for (ExecutionFuture executionFuture : toFail) {
            executionFuture.markFailed(LocalProblems.get().stopped());
        }
        if (join) {
            this.workerThreads.forEach(t -> {
                try {
                    t.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processWorkerResults() {
        Iterator<Worker> iterator = this.sleepMutex;
        synchronized (iterator) {
            this.workerFinished = false;
        }
        for (Worker worker : this.workers) {
            if (worker.isRunning()) continue;
            this.processLastTaskResult(worker);
        }
    }

    private int indexOfFirstIdleTask(TaskSpec spec) {
        int index = 0;
        for (WorkerTask task : this.waitingTasks) {
            if (task.getSpec() == spec && !task.hasPageInProgress()) break;
            ++index;
        }
        return index;
    }

    private void queueWork(WorkerTask task) {
        if (task.hasPageInProgress()) {
            this.waitingTasks.add(this.indexOfFirstIdleTask(task.getSpec()), task);
        } else {
            this.waitingTasks.add(task);
        }
    }

    private void processLastTaskResult(Worker worker) {
        Worker.Result workDone = worker.clearLastTask();
        if (workDone == null) {
            return;
        }
        WorkerTask lastTask = workDone.task;
        if (!this.runningTasks.contains(lastTask)) {
            return;
        }
        TaskSpec taskSpec = lastTask.getSpec();
        if (workDone.state == ReturnState.ERROR_THROWN) {
            this.processLastTaskError(workDone);
            return;
        }
        this.runningTasks.remove(lastTask);
        log.debug("Finished running task {} with {}", (Object)lastTask, (Object)workDone.state);
        if (workDone.state == ReturnState.COMPLETE) {
            if (lastTask.producesResult()) {
                Object processingResult = lastTask.consumeProcessingResult();
                if (processingResult == null) {
                    throw new NullPointerException("worker was supposed to produce a result " + String.valueOf(lastTask));
                }
                this.waitingTasks.stream().map(WorkerTask::getSpec).collect(Collectors.toSet()).forEach(waitingSpec -> {
                    if (waitingSpec.hasDependency(taskSpec)) {
                        waitingSpec.addProcessingResultFromDependency(taskSpec, processingResult);
                    } else if (waitingSpec.hadDependency(taskSpec)) {
                        throw new IllegalStateException("this should not happen - a worker has completed after a dependent was satisifed");
                    }
                });
            }
            this.taskComplete(lastTask);
        } else if (workDone.state != ReturnState.ERROR_THROWN) {
            this.queueWork(lastTask);
        }
        if (taskSpec.allWorkersMatch(wt -> wt.isComplete() || wt.isCreated())) {
            long tuplesRead = 0L;
            long tuplesWritten = 0L;
            for (WorkerTask task : taskSpec.getWorkerTasks()) {
                tuplesRead += task.getPageReader().map(r -> r.getTuplesRead()).orElse(0L).longValue();
                tuplesWritten += task.getPageWriter().map(w -> w.getTuplesWritten()).orElse(1L).longValue();
                if (!task.isCreated()) continue;
                task.markComplete();
                this.taskComplete(task);
            }
            taskSpec.changeState(TaskState.COMPLETE);
            taskSpec.close();
            if (this.taskProducedNoData && tuplesRead > 0L && tuplesWritten == 0L) {
                this.taskProducedNoData = false;
                this.problemSink.log(LocalProblems.get().noDataProduced(taskSpec.getStepsSummary()).withSeverity(Problem.Severity.WARNING));
            }
            log.info("Completed step(s) {}", (Object)taskSpec.getStepsSummary());
            taskSpec.getOutput().ifPresent(WritePageBuffer::markComplete);
            this.waitingTasks.stream().map(WorkerTask::getSpec).collect(Collectors.toSet()).forEach(waitingSpec -> {
                if (waitingSpec.hasDependency(taskSpec)) {
                    log.info("marking {}'s dependency on {} as satisfied", waitingSpec, (Object)taskSpec);
                    waitingSpec.satisfyDependency(taskSpec);
                }
            });
            this.cleanupMetrics(lastTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLastTaskError(Worker.Result workDone) {
        WorkerTask lastTask = workDone.task;
        this.taskComplete(lastTask);
        this.currentJob.markFailed(workDone.errorThrown);
        log.info("Current job has failed, waiting for other tasks to yield...");
        Object object = this.sleepMutex;
        synchronized (object) {
            while (this.workers.stream().anyMatch(Worker::isRunning)) {
                try {
                    this.sleepMutex.wait(0L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        log.info("All job's tasks have stopped, cleaning up after failure");
        this.cleanupCurrentJob();
    }

    private void cleanupCurrentJob() {
        this.runningTasks.forEach(this::closeTaskAndSwallowErrors);
        this.waitingTasks.forEach(this::closeTaskAndSwallowErrors);
        this.completedTasks.clear();
        this.waitingTasks.clear();
        this.runningTasks.clear();
        this.currentJob = null;
    }

    private void closeTaskAndSwallowErrors(WorkerTask task) {
        try {
            task.close();
        }
        catch (Throwable e) {
            log.error("Exception closing task {}", (Object)task, (Object)e);
        }
    }

    private void cleanupMetrics(WorkerTask task) {
        TaskSpec taskSpec = task.getSpec();
        MetricRegistry registry = taskSpec.getExecutionContext().getMetricRegistry();
        for (Map.Entry<String, Metric> metricEntry : taskSpec.getMetrics().entrySet()) {
            Metric metric = metricEntry.getValue();
            if (!(metric instanceof Metered)) continue;
            Metered meter = (Metered)metric;
            double average = meter.getOneMinuteRate();
            String name = task.getSpecNameBrief() + "." + metricEntry.getKey();
            registry.register(name + ".per-sec", (Metric)((Gauge)() -> average));
        }
        for (Map.Entry<String, Metric> keyMetric : taskSpec.getProgressMetrics().entrySet()) {
            taskSpec.getJobContext().getProgressMetrics().remove(task.getSpecNameBrief() + "." + keyMetric.getKey());
        }
    }

    private void taskComplete(WorkerTask task) {
        task.markComplete();
        if (!this.completedTasks.contains(task)) {
            this.waitingTasks.remove(task);
            this.completedTasks.add(task);
            try {
                task.close();
            }
            catch (RuntimeException e) {
                log.error("Exception closing task {} ", (Object)task, (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForNotify() {
        Object object = this.sleepMutex;
        synchronized (object) {
            if (this.workerFinished) {
                return;
            }
            try {
                int delay = this.numWorkersRunning() == (long)this.workers.size() ? 100 : 1;
                this.sleepMutex.wait(delay);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Scheduler interrupted", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void workerFinished() {
        Object object = this.sleepMutex;
        synchronized (object) {
            this.workerFinished = true;
            this.sleepMutex.notify();
        }
    }

    private Worker findFreeWorker(WorkerTask task) {
        for (Worker worker : this.workers) {
            if (worker.isRunning() || worker.lastResult.get() != null) continue;
            return worker;
        }
        return null;
    }

    private WorkerTask findNextTask() {
        for (WorkerTask task : this.waitingTasks) {
            if (!task.isReadyToRun()) continue;
            return task;
        }
        return this.waitingTasks.isEmpty() ? NO_TASKS_WAITING : NO_TASKS_READY;
    }

    List<WorkerTask> addTasks(List<TaskSpec> taskSpecs) throws ProblemException {
        ArrayList<WorkerTask> newTasks = new ArrayList<WorkerTask>(taskSpecs.size());
        LinkedList<Problem> failures = new LinkedList<Problem>();
        block3: for (TaskSpec spec : taskSpecs) {
            int threadsPerTask = spec.isParallelizable() ? this.params.getMaxThreadsPerTask() : 1;
            for (int i = 0; i < threadsPerTask; ++i) {
                try {
                    WorkerTask task = spec.newWorkerTask(this);
                    newTasks.add(task);
                    continue;
                }
                catch (ProblemException e) {
                    failures.addAll(e.getProblems());
                    continue block3;
                }
                catch (Throwable e) {
                    failures.add(Problems.caught((Throwable)e));
                }
            }
        }
        if (failures.size() > 0) {
            throw new ProblemException(failures);
        }
        this.waitingTasks.addAll(newTasks);
        return newTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<ExecutionResult> queueJob(PipelineJobContext context) {
        ExecutionFuture queuedJob = new ExecutionFuture(context);
        Object object = this.sleepMutex;
        synchronized (object) {
            if (this.stopped) {
                throw new RiskscapeException((Problems)LocalProblems.get().stopped());
            }
            if (this.schedulerThread.getState() == Thread.State.NEW) {
                this.schedulerThread.setDaemon(true);
                this.schedulerThread.start();
            }
            this.jobQueue.add(queuedJob);
            this.sleepMutex.notify();
        }
        return queuedJob;
    }

    void prepareNextJob(ExecutionFuture newJob) {
        List<WorkerTask> newTasks;
        this.currentJob = newJob;
        List<TaskSpec> newWork = this.buildTasks(this.currentJob);
        try {
            newTasks = this.addTasks(newWork);
        }
        catch (ProblemException e) {
            log.info("Failed to convert pipeline in to tasks, failing pipeline execution", (Throwable)e);
            this.currentJob.markFailed(e);
            this.cleanupCurrentJob();
            return;
        }
        if (newTasks.size() == 0) {
            this.currentJob.markComplete();
            this.cleanupCurrentJob();
        }
        log.info("Added {} new tasks", (Object)newTasks.size());
        if (log.isDebugEnabled()) {
            int ctr = 0;
            for (WorkerTask task : newTasks) {
                log.debug("  {}: {}", (Object)ctr++, (Object)task);
            }
        }
    }

    @Generated
    public List<WorkerTask> getWaitingTasks() {
        return this.waitingTasks;
    }

    @Generated
    public List<WorkerTask> getRunningTasks() {
        return this.runningTasks;
    }

    @Generated
    public List<WorkerTask> getCompletedTasks() {
        return this.completedTasks;
    }

    public static interface LocalProblems
    extends ProblemFactory {
        public static LocalProblems get() {
            return (LocalProblems)Problems.get(LocalProblems.class);
        }

        public Problem noDataProduced(String var1);

        public Problem crash(String var1);

        public Problem deadlock();

        public Problem stopped();
    }
}

