/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.sched;

import java.util.Optional;
import java.util.function.Predicate;
import lombok.Generated;
import nz.org.riskscape.engine.sched.Page;

public class PageAllocator {
    private static final int NO_MAX_SIZE = Integer.MAX_VALUE;
    private final int initialPageSize;
    private final int maxPageSize;
    private final Optional<Integer> doubleEveryNPages;
    private final Optional<Predicate<PageAllocator>> applyBackoff;
    private volatile long pagesAllocated = 0L;
    private int currentPageSize;

    public PageAllocator(int startAt, int maxSize, Optional<Integer> incrementPeriod, Optional<Predicate<PageAllocator>> backoff) {
        this.initialPageSize = startAt;
        this.maxPageSize = maxSize;
        this.doubleEveryNPages = incrementPeriod;
        this.applyBackoff = backoff;
        this.currentPageSize = startAt;
    }

    public PageAllocator(int fixedSize) {
        this(fixedSize, Integer.MAX_VALUE, Optional.empty(), Optional.empty());
    }

    public PageAllocator withMaxPageSize(int maxSize) {
        return new PageAllocator(Math.min(this.initialPageSize, maxSize), maxSize, this.doubleEveryNPages, this.applyBackoff);
    }

    public PageAllocator withBackoff(Predicate<PageAllocator> backoffWhen) {
        if (!this.doubleEveryNPages.isPresent()) {
            throw new IllegalStateException("Can only use backoff in combination with doubleEvery()");
        }
        return new PageAllocator(this.initialPageSize, this.maxPageSize, this.doubleEveryNPages, Optional.of(backoffWhen));
    }

    public PageAllocator doubleEvery(int nTimes) {
        return new PageAllocator(this.initialPageSize, this.maxPageSize, Optional.of(nTimes), this.applyBackoff);
    }

    private boolean shouldDoublePageSize() {
        return this.doubleEveryNPages.isPresent() && this.pagesAllocated != 0L && this.pagesAllocated % (long)this.doubleEveryNPages.get().intValue() == 0L;
    }

    public boolean isBackoffNeeded() {
        return this.applyBackoff.map(backoff -> backoff.test(this)).orElse(false);
    }

    protected int getPageSize() {
        if (this.isBackoffNeeded()) {
            this.currentPageSize = this.initialPageSize;
        } else if (this.shouldDoublePageSize()) {
            this.currentPageSize = Math.min(this.currentPageSize * 2, this.maxPageSize);
        }
        return this.currentPageSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page newPage() {
        PageAllocator pageAllocator = this;
        synchronized (pageAllocator) {
            Page page = new Page(this.getPageSize());
            ++this.pagesAllocated;
            return page;
        }
    }

    @Generated
    public int getMaxPageSize() {
        return this.maxPageSize;
    }
}

