/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.sched;

import java.util.NoSuchElementException;
import lombok.Generated;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.relation.TupleIterator;

public class Page {
    private final Tuple[] data;
    private final int maxSize;
    private int writeIndex = 0;

    public Page(int pageSize) {
        this.data = new Tuple[pageSize];
        this.maxSize = pageSize;
    }

    public int getTupleCount() {
        return this.writeIndex;
    }

    public boolean isFull() {
        return this.writeIndex >= this.maxSize;
    }

    public void add(Tuple tuple) {
        if (this.isFull()) {
            throw new IllegalStateException("Cannot add tuple - page is full");
        }
        this.data[this.writeIndex++] = tuple;
    }

    public String toString() {
        return String.format("Page[written %d/%d tuples]", this.getTupleCount(), this.getMaxSize());
    }

    public ReadOnlyPage getReadOnlyCopy() {
        return new ReadOnlyPage();
    }

    @Generated
    public int getMaxSize() {
        return this.maxSize;
    }

    public class ReadOnlyPage
    implements TupleIterator {
        private int readIndex = 0;

        public Tuple next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more tuples left in page to read. " + this.toString());
            }
            return Page.this.data[this.readIndex++];
        }

        public Tuple peek() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more tuples left in page to peek. " + this.toString());
            }
            return Page.this.data[this.readIndex];
        }

        public boolean hasNext() {
            return this.readIndex < this.getTupleCount();
        }

        public String toString() {
            return String.format("Page[read %d/%d tuples]", this.readIndex + 1, this.getTupleCount());
        }

        public int getTupleCount() {
            return Page.this.writeIndex;
        }
    }
}

