/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.sched;

import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.join.LopsidedJoiner;
import nz.org.riskscape.engine.output.PipelineJobContext;
import nz.org.riskscape.engine.pipeline.Sink;
import nz.org.riskscape.engine.pipeline.SinkConstructor;
import nz.org.riskscape.engine.projection.FlatProjector;
import nz.org.riskscape.engine.relation.TupleIterator;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.problem.ResultOrProblems;

public class LopsidedJoinAdapter<T> {
    private LopsidedJoiner<T> joiner;
    private T index;

    public LopsidedJoinAdapter(LopsidedJoiner<T> joiner) {
        this.joiner = joiner;
        this.index = joiner.createRhsIndex();
    }

    public SinkConstructor newSinkConstructor() {
        return new SinkConstructor(){

            public ResultOrProblems<Sink> newInstance(PipelineJobContext context) {
                return ResultOrProblems.of((Object)new SinkImpl());
            }
        };
    }

    public FlatProjector newFlatProjector() {
        return new FlatProjectorImpl();
    }

    private class FlatProjectorImpl
    implements FlatProjector {
        private FlatProjectorImpl() {
        }

        public Struct getSourceType() {
            return LopsidedJoinAdapter.this.joiner.getLhs();
        }

        public Struct getProducedType() {
            return LopsidedJoinAdapter.this.joiner.getProducedType();
        }

        public TupleIterator apply(Tuple tuple) {
            return LopsidedJoinAdapter.this.joiner.join(LopsidedJoinAdapter.this.index, tuple);
        }

        public void close() {
            LopsidedJoinAdapter.this.index = null;
        }
    }

    private class SinkImpl
    implements Sink {
        private SinkImpl() {
        }

        public boolean accept(Tuple tuple) {
            LopsidedJoinAdapter.this.joiner.addToRhsIndex(tuple, LopsidedJoinAdapter.this.index);
            return true;
        }

        public void finish() {
        }
    }
}

