/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.sched;

import java.util.ArrayList;
import lombok.Generated;
import nz.org.riskscape.engine.sched.Page;
import nz.org.riskscape.engine.sched.PageAllocator;
import nz.org.riskscape.engine.task.PageBuffer;
import nz.org.riskscape.engine.task.ReadPageBuffer;

public class LinkedListBuffer
implements PageBuffer {
    private static final Page COMPLETE = new Page(0);
    private static final Page EMPTY = new Page(0);
    private volatile Node start;
    private volatile Node end;
    public static final int DEFAULT_PAGE_SIZE = 1024;
    public static final int DEFAULT_CAPACITY = 8;
    private final PageAllocator allocator;
    private final int tupleCapacity;
    private volatile long tuplesAllocated;
    private volatile long tuplesWritten;
    private volatile long tuplesRead;
    private final ArrayList<Clone> clones;

    protected LinkedListBuffer() {
        this(1024, 8);
    }

    protected LinkedListBuffer(int pageSize, int pageCapacity) {
        this(new PageAllocator(pageSize), pageSize * pageCapacity);
    }

    public LinkedListBuffer withMaxPageSize(int pageSize) {
        return new LinkedListBuffer(this.allocator.withMaxPageSize(pageSize), this.tupleCapacity);
    }

    public int getMaxPageSize() {
        return this.allocator.getMaxPageSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Page newPage() {
        LinkedListBuffer linkedListBuffer = this;
        synchronized (linkedListBuffer) {
            Page page = this.allocator.newPage();
            this.tuplesAllocated += (long)page.getMaxSize();
            return page;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Page page) {
        int numTuplesInPage = page.getTupleCount();
        LinkedListBuffer linkedListBuffer = this;
        synchronized (linkedListBuffer) {
            this.end.next = new Node();
            this.end.page = page;
            this.end = this.end.next;
            this.tuplesWritten += (long)numTuplesInPage;
            if (this.tuplesAllocated < (long)page.getMaxSize()) {
                throw new IllegalStateException("Error calculating tuples allocated to buffer");
            }
            this.tuplesAllocated -= (long)page.getMaxSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFull() {
        int tuplesInBuffer = this.size();
        LinkedListBuffer linkedListBuffer = this;
        synchronized (linkedListBuffer) {
            return this.tuplesAllocated + (long)tuplesInBuffer >= (long)this.getTupleCapacity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        LinkedListBuffer linkedListBuffer = this;
        synchronized (linkedListBuffer) {
            return this.start.page == EMPTY || this.start.page == COMPLETE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Page.ReadOnlyPage read() {
        Page.ReadOnlyPage page = null;
        LinkedListBuffer linkedListBuffer = this;
        synchronized (linkedListBuffer) {
            if (!this.isEmpty()) {
                page = this.start.page.getReadOnlyCopy();
                this.start = this.start.next;
            }
        }
        if (page != null) {
            int numTuplesInPage = page.getTupleCount();
            LinkedListBuffer linkedListBuffer2 = this;
            synchronized (linkedListBuffer2) {
                this.tuplesRead += (long)numTuplesInPage;
            }
        }
        return page;
    }

    @Override
    public void markComplete() {
        this.add(COMPLETE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isComplete() {
        LinkedListBuffer linkedListBuffer = this;
        synchronized (linkedListBuffer) {
            return this.start.page == COMPLETE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        long minTuplesRead = this.getMinTuplesRead();
        LinkedListBuffer linkedListBuffer = this;
        synchronized (linkedListBuffer) {
            return (int)(this.tuplesWritten - minTuplesRead);
        }
    }

    public String toString() {
        if (this.isComplete()) {
            return String.format("%s[complete!, tuples-in=%d tuples-out=%d]", this.getClass().getSimpleName(), this.tuplesWritten, this.tuplesRead);
        }
        return String.format("%s[size=%d, tuples-in=%d tuples-out=%d]", this.getClass().getSimpleName(), this.size(), this.tuplesWritten, this.tuplesRead);
    }

    @Override
    public ReadPageBuffer newReaderClone() {
        Clone clone = new Clone();
        this.clones.add(clone);
        return clone;
    }

    private long getMinTuplesRead() {
        long min = this.tuplesRead;
        for (Clone clone : this.clones) {
            min = Math.min(min, clone.cloneTuplesRead);
        }
        return min;
    }

    @Override
    public long numTuplesWritten() {
        return this.tuplesWritten;
    }

    @Override
    public long numTuplesRead() {
        return this.tuplesRead;
    }

    @Generated
    public LinkedListBuffer(PageAllocator allocator, int tupleCapacity) {
        this.end = this.start = new Node();
        this.tuplesAllocated = 0L;
        this.tuplesWritten = 0L;
        this.tuplesRead = 0L;
        this.clones = new ArrayList();
        this.allocator = allocator;
        this.tupleCapacity = tupleCapacity;
    }

    @Override
    @Generated
    public int getTupleCapacity() {
        return this.tupleCapacity;
    }

    private static class Node {
        Page page = EMPTY;
        Node next;

        private Node() {
        }
    }

    private class Clone
    implements ReadPageBuffer {
        volatile Node cloneStart;
        volatile long cloneTuplesRead;

        private Clone() {
            this.cloneStart = LinkedListBuffer.this.start;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Page.ReadOnlyPage read() {
            Page.ReadOnlyPage page = null;
            Clone clone = this;
            synchronized (clone) {
                if (!this.isEmpty()) {
                    page = this.cloneStart.page.getReadOnlyCopy();
                    this.cloneStart = this.cloneStart.next;
                    this.cloneTuplesRead += (long)page.getTupleCount();
                }
            }
            return page;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isComplete() {
            Clone clone = this;
            synchronized (clone) {
                return this.cloneStart.page == COMPLETE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Clone clone = this;
            synchronized (clone) {
                return this.cloneStart.page == EMPTY || this.cloneStart.page == COMPLETE;
            }
        }

        @Override
        public int size() {
            return (int)(LinkedListBuffer.this.tuplesWritten - this.cloneTuplesRead);
        }

        @Override
        public long numTuplesRead() {
            return this.cloneTuplesRead;
        }
    }
}

