/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.sched;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.output.PipelineJobContext;
import nz.org.riskscape.engine.pipeline.ExecutionResult;
import nz.org.riskscape.engine.sched.Scheduler;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionFuture
implements Future<ExecutionResult> {
    private static final Logger LOG = LoggerFactory.getLogger(Scheduler.class);
    private final PipelineJobContext jobContext;
    private final AtomicReference<Object> result = new AtomicReference();

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.result.get() != null;
    }

    @Override
    public ExecutionResult get() throws InterruptedException, ExecutionException {
        try {
            return this.get(0L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new AssertionError((Object)"we should never timeout with wait of 0");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionResult get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        ExecutionResult executionResult;
        if (!this.isDone()) {
            AtomicReference<Object> atomicReference = this.result;
            synchronized (atomicReference) {
                this.result.wait(unit.toMillis(timeout));
            }
        }
        if ((executionResult = this.result()) == null) {
            throw new TimeoutException();
        }
        return executionResult;
    }

    void markFailed(Problem problem) {
        this.markFailed(new RiskscapeException((Problems)problem));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markFailed(Throwable throwable) {
        if (this.result.compareAndSet(null, throwable)) {
            AtomicReference<Object> atomicReference = this.result;
            synchronized (atomicReference) {
                this.result.notifyAll();
            }
        } else {
            if (this.result.get() instanceof ExecutionResult) {
                throw new AssertionError("Job has completed, failure afterwards shouldn't happen", throwable);
            }
            LOG.info("Job {} is already marked failed, ignoring exception {}", (Object)this.jobContext, (Object)throwable);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markComplete() {
        if (this.result.compareAndSet(null, new ExecutionResult(this.jobContext))) {
            AtomicReference<Object> atomicReference = this.result;
            synchronized (atomicReference) {
                this.result.notifyAll();
            }
        } else {
            Exception marker = new Exception();
            marker.fillInStackTrace();
            LOG.warn("Job already complete, has been marked complete again from ", (Throwable)marker);
        }
    }

    private ExecutionResult result() throws ExecutionException {
        Object value = this.result.get();
        if (value instanceof Throwable) {
            throw new ExecutionException((Throwable)value);
        }
        return (ExecutionResult)value;
    }

    @Generated
    public ExecutionFuture(PipelineJobContext jobContext) {
        this.jobContext = jobContext;
    }

    @Generated
    PipelineJobContext getJobContext() {
        return this.jobContext;
    }
}

