/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.sched;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.engine.sched.Page;
import nz.org.riskscape.engine.task.ReadPageBuffer;

public class CombinedPageBuffer
implements ReadPageBuffer {
    private final List<ReadPageBuffer> buffers;

    public CombinedPageBuffer(ReadPageBuffer ... toRead) {
        this(Arrays.asList(toRead));
    }

    @Override
    public boolean isEmpty() {
        return this.buffers.stream().allMatch(buffer -> buffer.isEmpty());
    }

    @Override
    public boolean isComplete() {
        return this.buffers.stream().allMatch(buffer -> buffer.isComplete());
    }

    @Override
    public Page.ReadOnlyPage read() {
        ArrayList<ReadPageBuffer> buffersAtRandom = new ArrayList<ReadPageBuffer>(this.buffers);
        Collections.shuffle(buffersAtRandom);
        for (ReadPageBuffer buffer : buffersAtRandom) {
            Page.ReadOnlyPage page = buffer.read();
            if (page == null) continue;
            return page;
        }
        return null;
    }

    @Override
    public long numTuplesRead() {
        return this.buffers.stream().collect(Collectors.summingLong(buffer -> buffer.numTuplesRead()));
    }

    @Override
    public int size() {
        return this.buffers.stream().collect(Collectors.summingInt(buffer -> buffer.size()));
    }

    @Generated
    public CombinedPageBuffer(List<ReadPageBuffer> buffers) {
        this.buffers = buffers;
    }
}

