/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.sched;

import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.output.PipelineJobContext;
import nz.org.riskscape.engine.pipeline.Collector;
import nz.org.riskscape.engine.pipeline.Sink;
import nz.org.riskscape.engine.pipeline.SinkConstructor;
import nz.org.riskscape.problem.ResultOrProblems;

public class AccumulatorSink
implements Sink {
    private final Collector[] collectors;
    private final Object[] accumulators;
    private boolean finished = false;

    public AccumulatorSink(List<Collector<?>> collectors) {
        this.collectors = collectors.toArray(new Collector[0]);
        this.accumulators = collectors.stream().map(Collector::newAccumulator).collect(Collectors.toList()).toArray();
    }

    public boolean accept(Tuple tuple) {
        for (int i = 0; i < this.collectors.length; ++i) {
            this.collectors[i].accumulate(this.accumulators[i], tuple);
        }
        return true;
    }

    public Object getAndClearAccumulator(Collector forCollector) {
        if (!this.finished) {
            throw new IllegalStateException("Cannot clear while accumulating still in progress!");
        }
        for (int i = 0; i < this.collectors.length; ++i) {
            if (this.collectors[i] != forCollector) continue;
            Object accumulator = this.accumulators[i];
            this.accumulators[i] = null;
            return accumulator;
        }
        return null;
    }

    public void finish() {
        this.finished = true;
    }

    public boolean isUnbounded() {
        return true;
    }

    public boolean canAccept() {
        return true;
    }

    public static class Constructor
    implements SinkConstructor {
        private final List<Collector<?>> collectors;

        public ResultOrProblems<Sink> newInstance(PipelineJobContext jobContext) {
            return ResultOrProblems.of((Object)new AccumulatorSink(this.collectors));
        }

        @Generated
        public Constructor(List<Collector<?>> collectors) {
            this.collectors = collectors;
        }
    }
}

