/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.rl.agg;

import java.util.List;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.rl.agg.ListCollecting;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.rl.ast.FunctionCall;

public class StandardDeviationAggregationFunction
extends ListCollecting {
    public static final Struct RESULT_TYPE = Struct.of((String)"mean", (Type)Types.FLOATING, (String)"stddev", (Type)Types.FLOATING);
    public static final int SQUARED = 2;
    public static final int MIN_VALUES_REQUIRED = 2;

    @Override
    protected ListCollecting.ListProcessor buildProcessor(RSList listType, RealizationContext context, Type inputType, FunctionCall fc) throws ProblemException {
        if (!listType.getMemberType().isNumeric()) {
            throw new ProblemException((Problems)ListCollecting.LocalProblems.get().valueNotNumeric("stddev", listType.getMemberType()));
        }
        return new ListCollecting.ListProcessor(Nullable.of((Type)RESULT_TYPE), StandardDeviationAggregationFunction::pickStddev);
    }

    private static Object pickStddev(List values) {
        List numbers = values;
        if (numbers.size() < 2) {
            return null;
        }
        double total = 0.0;
        for (Number value : numbers) {
            total += value.doubleValue();
        }
        double mean = total / (double)numbers.size();
        double sum = 0.0;
        for (Number value : numbers) {
            sum += Math.pow(value.doubleValue() - mean, 2.0);
        }
        double stddev = Math.sqrt(sum / (double)(numbers.size() - 1));
        return Tuple.ofValues((Struct)RESULT_TYPE, (Object[])new Object[]{mean, stddev});
    }
}

