/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.rl.agg;

import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.rl.agg.ListCollecting;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.rl.ast.ExpressionProblems;
import nz.org.riskscape.rl.ast.FunctionCall;

public class PercentileAggregationFunction
extends ListCollecting {
    public static final Type PERCENTILE_TYPE = Types.INTEGER;
    public static final RSList PERCENTILES_TYPE = RSList.create((Type)PERCENTILE_TYPE);

    public ArgumentList getArguments() {
        return ArgumentList.create((String)"items", (Type)RSList.LIST_ANYTHING, (String)"percentiles", (Type)RSList.create((Type)Types.INTEGER));
    }

    @Override
    protected ListCollecting.ListProcessor buildProcessor(RSList listType, RealizationContext context, Type inputType, FunctionCall fc) throws ProblemException {
        if (!listType.getMemberType().isNumeric()) {
            throw new ProblemException((Problems)ListCollecting.LocalProblems.get().valueNotNumeric("percentiles", listType.getMemberType()));
        }
        List<Long> percentiles = this.getPercentiles(context, fc);
        Type resultType = this.getResultTypeFor(listType.getMemberType(), percentiles);
        return new ListCollecting.ListProcessor(resultType, values -> this.buildResult(this.pickPercentiles((List)values, percentiles), resultType));
    }

    protected List<Long> getPercentiles(RealizationContext context, FunctionCall fc) throws ProblemException {
        if (fc.getArguments().size() != 2) {
            throw new ProblemException((Problems)ArgsProblems.get().wrongNumber(2, fc.getArguments().size()));
        }
        RealizedExpression percentilesExpression = (RealizedExpression)context.getExpressionRealizer().realize((Type)Struct.EMPTY_STRUCT, ((FunctionCall.Argument)fc.getArguments().get(1)).getExpression()).orElse(null);
        if (percentilesExpression == null) {
            throw new ProblemException((Problems)ExpressionProblems.get().constantRequired(((FunctionCall.Argument)fc.getArguments().get(1)).getExpression()));
        }
        RSList percentilesType = (RSList)Types.findOrThrow(fc.getArguments().get(1), (Type)PERCENTILES_TYPE, (Type)percentilesExpression.getResultType());
        Types.findOrThrow(fc.getArguments().get(1), (Type)PERCENTILE_TYPE, (Type)percentilesType.getContainedType());
        return (List)percentilesExpression.evaluate((Object)Tuple.EMPTY_TUPLE);
    }

    private Object[] pickPercentiles(List values, List<Long> percentiles) {
        List numbers = values;
        numbers.sort((l, r) -> ((Comparable)((Object)l)).compareTo(r));
        Object[] results = new Object[percentiles.size()];
        for (int i = 0; i < percentiles.size(); ++i) {
            int percentile = percentiles.get(i).intValue();
            int index = percentile * numbers.size() / 100;
            if (index >= numbers.size()) {
                index = numbers.size() - 1;
            }
            results[i] = numbers.get(index);
        }
        return results;
    }

    protected Object buildResult(Object[] results, Type resultType) {
        return Tuple.ofValues((Struct)Nullable.strip((Type)resultType).asStruct(), (Object[])results);
    }

    protected Type getResultTypeFor(Type internalType, List<Long> percentiles) throws ProblemException {
        Struct.StructBuilder sb = Struct.builder();
        boolean nullable = Nullable.is((Type)internalType);
        for (Long percentile : percentiles) {
            if (percentile < 0L || percentile > 100L) {
                throw new ProblemException((Problems)LocalProblems.get().percentileOutOfRange(percentile));
            }
            sb.add(String.format("P%02d", percentile), Nullable.strip((Type)internalType));
        }
        return Nullable.ifTrue((boolean)nullable, (Type)((Type)sb.buildOr().getOrThrow()));
    }

    public static interface LocalProblems
    extends ProblemFactory {
        public static LocalProblems get() {
            return (LocalProblems)Problems.get(LocalProblems.class);
        }

        public Problem percentileOutOfRange(Long var1);
    }

    public static class Single
    extends PercentileAggregationFunction {
        @Override
        protected List<Long> getPercentiles(RealizationContext context, FunctionCall fc) throws ProblemException {
            if (fc.getArguments().size() != 2) {
                throw new ProblemException((Problems)ArgsProblems.get().wrongNumber(2, fc.getArguments().size()));
            }
            RealizedExpression percentilesExpression = (RealizedExpression)context.getExpressionRealizer().realize((Type)Struct.EMPTY_STRUCT, ((FunctionCall.Argument)fc.getArguments().get(1)).getExpression()).orElse(null);
            if (percentilesExpression == null) {
                throw new ProblemException((Problems)ExpressionProblems.get().constantRequired(((FunctionCall.Argument)fc.getArguments().get(1)).getExpression()));
            }
            Types.findOrThrow(fc.getArguments().get(1), (Type)PERCENTILE_TYPE, (Type)percentilesExpression.getResultType());
            return Arrays.asList((Long)percentilesExpression.evaluate((Object)Tuple.EMPTY_TUPLE));
        }

        @Override
        protected Type getResultTypeFor(Type internalType, List<Long> percentiles) throws ProblemException {
            return internalType;
        }

        @Override
        protected Object buildResult(Object[] results, Type resultType) {
            return results[0];
        }

        @Generated
        public Single() {
        }
    }

    public static class SingleFixed
    extends PercentileAggregationFunction {
        private final Long percentile;

        @Override
        public ArgumentList getArguments() {
            return ArgumentList.create((String)"items", (Type)RSList.LIST_ANYTHING, (String)"percentile", (Type)Types.INTEGER);
        }

        @Override
        protected List<Long> getPercentiles(RealizationContext context, FunctionCall fc) throws ProblemException {
            if (fc.getArguments().size() != 1) {
                throw new ProblemException((Problems)ArgsProblems.get().wrongNumber(1, fc.getArguments().size()));
            }
            return Arrays.asList(this.percentile);
        }

        @Override
        protected Type getResultTypeFor(Type internalType, List<Long> percentiles) throws ProblemException {
            return internalType;
        }

        @Override
        protected Object buildResult(Object[] results, Type resultType) {
            return results[0];
        }

        @Generated
        public SingleFixed(Long percentile) {
            this.percentile = percentile;
        }
    }
}

