/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.rl.agg;

import java.util.List;
import java.util.function.Function;
import lombok.Generated;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.rl.agg.Accumulator;
import nz.org.riskscape.engine.rl.agg.AggregationFunction;
import nz.org.riskscape.engine.rl.agg.RealizedAggregateExpression;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.util.SegmentedList;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.FunctionCall;

public abstract class ListCollecting
implements AggregationFunction {
    public ResultOrProblems<RealizedAggregateExpression> realize(RealizationContext context, final Type inputType, final FunctionCall fc) {
        return ProblemException.catching(() -> {
            if (fc.getArguments().size() == 0) {
                throw new ProblemException((Problems)ArgsProblems.get().wrongNumber(1, 0));
            }
            FunctionCall.Argument arg = (FunctionCall.Argument)fc.getArguments().get(0);
            final RealizedExpression valueExpression = (RealizedExpression)context.getExpressionRealizer().realize(inputType, arg.getExpression()).getOrThrow(Problems.foundWith((Object)arg, (Problem[])new Problem[0]));
            RSList listType = RSList.create((Type)valueExpression.getResultType());
            final ListProcessor processor = this.buildProcessor(listType, context, inputType, fc);
            final Type resultType = processor.identity != null ? Nullable.strip((Type)processor.getResultType()) : processor.getResultType();
            return new RealizedAggregateExpression(){

                public Accumulator newAccumulator() {
                    return new AccumInstance(SegmentedList.forType((Type)valueExpression.getResultType()), valueExpression, processor);
                }

                public Type getResultType() {
                    return resultType;
                }

                public Type getInputType() {
                    return inputType;
                }

                public Expression getExpression() {
                    return fc;
                }
            };
        }).composeProblems(Problems.foundWith((Object)fc, (Problem[])new Problem[0]));
    }

    protected abstract ListProcessor buildProcessor(RSList var1, RealizationContext var2, Type var3, FunctionCall var4) throws ProblemException;

    public static class ListProcessor {
        private final Type resultType;
        private final Function<List<Object>, Object> processFunction;
        private final Object identity;

        public ListProcessor(Type resultType, Function<List<Object>, Object> processFunction) {
            this.resultType = resultType;
            this.processFunction = processFunction;
            this.identity = null;
        }

        @Generated
        public Type getResultType() {
            return this.resultType;
        }

        @Generated
        public Function<List<Object>, Object> getProcessFunction() {
            return this.processFunction;
        }

        @Generated
        public Object getIdentity() {
            return this.identity;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ListProcessor)) {
                return false;
            }
            ListProcessor other = (ListProcessor)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Type this$resultType = this.getResultType();
            Type other$resultType = other.getResultType();
            if (this$resultType == null ? other$resultType != null : !this$resultType.equals(other$resultType)) {
                return false;
            }
            Function<List<Object>, Object> this$processFunction = this.getProcessFunction();
            Function<List<Object>, Object> other$processFunction = other.getProcessFunction();
            if (this$processFunction == null ? other$processFunction != null : !this$processFunction.equals(other$processFunction)) {
                return false;
            }
            Object this$identity = this.getIdentity();
            Object other$identity = other.getIdentity();
            return !(this$identity == null ? other$identity != null : !this$identity.equals(other$identity));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ListProcessor;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Type $resultType = this.getResultType();
            result = result * 59 + ($resultType == null ? 43 : $resultType.hashCode());
            Function<List<Object>, Object> $processFunction = this.getProcessFunction();
            result = result * 59 + ($processFunction == null ? 43 : $processFunction.hashCode());
            Object $identity = this.getIdentity();
            result = result * 59 + ($identity == null ? 43 : $identity.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ListCollecting.ListProcessor(resultType=" + String.valueOf(this.getResultType()) + ", processFunction=" + String.valueOf(this.getProcessFunction()) + ", identity=" + String.valueOf(this.getIdentity()) + ")";
        }

        @Generated
        public ListProcessor(Type resultType, Function<List<Object>, Object> processFunction, Object identity) {
            this.resultType = resultType;
            this.processFunction = processFunction;
            this.identity = identity;
        }
    }

    private static class AccumInstance
    implements Accumulator {
        private final List accumulated;
        private final RealizedExpression valueExpression;
        private final ListProcessor listProcessor;

        public Accumulator combine(Accumulator other) {
            AccumInstance rhs = (AccumInstance)other;
            this.accumulated.addAll(rhs.accumulated);
            return this;
        }

        public void accumulate(Object input) {
            Object toAccumulate = this.valueExpression.evaluate(input);
            if (toAccumulate == null) {
                return;
            }
            this.accumulated.add(toAccumulate);
        }

        public Object process() {
            if (this.accumulated.isEmpty()) {
                return this.listProcessor.identity;
            }
            Object processResult = this.listProcessor.getProcessFunction().apply(this.accumulated);
            if (processResult == null) {
                return this.listProcessor.identity;
            }
            return processResult;
        }

        public boolean isEmpty() {
            return this.accumulated.isEmpty() && this.listProcessor.getIdentity() == null;
        }

        @Generated
        public AccumInstance(List accumulated, RealizedExpression valueExpression, ListProcessor listProcessor) {
            this.accumulated = accumulated;
            this.valueExpression = valueExpression;
            this.listProcessor = listProcessor;
        }
    }

    public static interface LocalProblems
    extends ProblemFactory {
        public static LocalProblems get() {
            return (LocalProblems)Problems.get(LocalProblems.class);
        }

        public Problem valueNotNumeric(String var1, Type var2);
    }
}

