/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.rl.agg;

import com.google.common.collect.Streams;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.rl.agg.Accumulator;
import nz.org.riskscape.engine.types.Struct;

public class ExpressionAccumulator
implements Accumulator {
    private final List<Accumulator> children;
    private final RealizedExpression processExpression;

    public void accumulate(Object input) {
        for (Accumulator child : this.children) {
            child.accumulate(input);
        }
    }

    public Accumulator combine(Accumulator rhs) {
        ExpressionAccumulator other = (ExpressionAccumulator)rhs;
        List<Accumulator> combinedChildren = Streams.zip(this.children.stream(), other.children.stream(), (l, r) -> l.combine(r)).collect(Collectors.toList());
        return new ExpressionAccumulator(combinedChildren, this.processExpression);
    }

    public Object process() {
        Tuple input = new Tuple((Struct)this.processExpression.getInputType().find(Struct.class).get());
        for (int index = 0; index < this.children.size(); ++index) {
            input.set(index, this.children.get(index).process());
        }
        return this.processExpression.evaluate((Object)input);
    }

    public boolean isEmpty() {
        for (Accumulator accumulator : this.children) {
            if (accumulator.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Generated
    public ExpressionAccumulator(List<Accumulator> children, RealizedExpression processExpression) {
        this.children = children;
        this.processExpression = processExpression;
    }
}

