/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.rl.agg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.engine.NoSuchObjectException;
import nz.org.riskscape.engine.function.IdentifiedFunction;
import nz.org.riskscape.engine.rl.ExpressionRealizer;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.rl.UnresolvedExpressionParameterException;
import nz.org.riskscape.engine.rl.agg.AggregationFunction;
import nz.org.riskscape.engine.rl.agg.ExpressionAccumulator;
import nz.org.riskscape.engine.rl.agg.RealizedAggregateExpression;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.util.Pair;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.BinaryOperation;
import nz.org.riskscape.rl.ast.BracketedExpression;
import nz.org.riskscape.rl.ast.Constant;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.ExpressionProblems;
import nz.org.riskscape.rl.ast.ExpressionVisitor;
import nz.org.riskscape.rl.ast.FunctionCall;
import nz.org.riskscape.rl.ast.Lambda;
import nz.org.riskscape.rl.ast.ListDeclaration;
import nz.org.riskscape.rl.ast.ParameterToken;
import nz.org.riskscape.rl.ast.PropertyAccess;
import nz.org.riskscape.rl.ast.SelectAllExpression;
import nz.org.riskscape.rl.ast.StructDeclaration;

public class AggregateExpressionRealizer
implements ExpressionVisitor<List<Problem>, Expression> {
    private final RealizationContext context;
    private final Type inputType;
    private final Expression root;
    private Map<FunctionCall, Pair<RealizedAggregateExpression, String>> realizedFunctions = new HashMap<FunctionCall, Pair<RealizedAggregateExpression, String>>();
    private List<Problem> allProblems = new ArrayList<Problem>();

    public static String getImplicitName(FunctionCall aggregateFunctionCall, Collection<String> used) {
        Object ident = aggregateFunctionCall.getIdentifier().getValue();
        if (aggregateFunctionCall.getArguments().size() == 1) {
            ident = (String)ident + ((FunctionCall.Argument)aggregateFunctionCall.getArguments().get(0)).getExpression().isA(PropertyAccess.class).map(pa -> "_" + pa.getLastIdentifier().rawValue()).orElse("");
        }
        return ExpressionRealizer.makeUnique((String)ident, used);
    }

    public ResultOrProblems<RealizedAggregateExpression> realize() {
        Expression rewritten = (Expression)this.root.accept((ExpressionVisitor)this, this.allProblems);
        Struct.StructBuilder builder = Struct.builder();
        for (Pair<RealizedAggregateExpression, String> entry : this.realizedFunctions.values()) {
            builder.add((String)entry.getRight(), ((RealizedAggregateExpression)entry.getLeft()).getResultType());
        }
        if (this.allProblems.size() > 0) {
            return ResultOrProblems.failed(this.allProblems);
        }
        Struct processingInputType = builder.build();
        RealizedExpression processingExpression = (RealizedExpression)this.collect(this.context.getExpressionRealizer().realize((Type)processingInputType, rewritten));
        if (processingExpression == null) {
            return ResultOrProblems.failed(this.allProblems);
        }
        return ResultOrProblems.of((Object)RealizedAggregateExpression.create((Type)this.inputType, (Type)processingExpression.getResultType(), (Expression)this.root, () -> new ExpressionAccumulator(this.realizedFunctions.values().stream().map(r -> ((RealizedAggregateExpression)r.getLeft()).newAccumulator()).collect(Collectors.toList()), processingExpression)));
    }

    public Expression visit(BinaryOperation expression, List<Problem> data) {
        return new BinaryOperation((Expression)expression.getLhs().accept((ExpressionVisitor)this, data), expression.getOperator(), (Expression)expression.getRhs().accept((ExpressionVisitor)this, data));
    }

    public Expression visit(BracketedExpression expression, List<Problem> data) {
        return new BracketedExpression((Expression)expression.accept((ExpressionVisitor)this, data), Optional.empty());
    }

    public Expression visit(Constant expression, List<Problem> data) {
        return expression;
    }

    public Expression visit(FunctionCall expression, List<Problem> data) {
        IdentifiedFunction function;
        String id = expression.getIdentifier().getValue();
        String ident = AggregateExpressionRealizer.getImplicitName(expression, this.realizedFunctions.values().stream().map(Pair::getRight).collect(Collectors.toSet()));
        PropertyAccess substitute = PropertyAccess.of((String[])new String[]{ident});
        if (this.realizedFunctions.containsKey(expression)) {
            return substitute;
        }
        try {
            function = (IdentifiedFunction)this.context.getProject().getFunctionSet().get(id);
        }
        catch (NoSuchObjectException ex) {
            data.add(Problems.caught((Throwable)ex));
            return expression;
        }
        AggregationFunction aggFunction = function.getAggregationFunction().orElse(null);
        if (aggFunction == null) {
            return this.rewrite(expression, data);
        }
        ResultOrProblems realizedFunction = aggFunction.realize(this.context, this.inputType, expression);
        if (realizedFunction.hasErrors()) {
            data.add(ExpressionProblems.get().failedToRealize((Expression)expression, this.inputType).withChildren(realizedFunction.getProblems()));
            return expression;
        }
        this.realizedFunctions.put(expression, (Pair<RealizedAggregateExpression, String>)Pair.of((Object)((RealizedAggregateExpression)realizedFunction.get()), (Object)ident));
        return substitute;
    }

    private Expression rewrite(FunctionCall expression, List<Problem> data) {
        List rewrittenArguments = expression.getArguments().stream().map(arg -> new FunctionCall.Argument((Expression)arg.getExpression().accept((ExpressionVisitor)this, (Object)data), arg.getNameToken())).collect(Collectors.toList());
        return new FunctionCall(expression.getIdentifier(), rewrittenArguments);
    }

    private <T> T collect(ResultOrProblems<T> realize) {
        if (realize.hasErrors()) {
            this.allProblems.addAll(realize.getProblems());
            return null;
        }
        return (T)realize.get();
    }

    public Expression visit(ListDeclaration expression, List<Problem> data) {
        return new ListDeclaration(expression.getElements().stream().map(expr -> (Expression)expr.accept((ExpressionVisitor)this, (Object)data)).collect(Collectors.toList()), Optional.empty());
    }

    public Expression visit(PropertyAccess expression, List<Problem> data) {
        data.add(ExpressionProblems.get().propertyOutsideOfAggregationFunction(expression));
        return expression;
    }

    public Expression visit(StructDeclaration expression, List<Problem> data) {
        return new StructDeclaration(expression.getMembers().stream().map(member -> member.cloneWithExpression((Expression)member.getExpression().accept((ExpressionVisitor)this, (Object)data))).collect(Collectors.toList()), Optional.empty());
    }

    public Expression visit(SelectAllExpression expression, List<Problem> data) {
        return expression;
    }

    public Expression visit(Lambda expression, List<Problem> data) {
        return new Lambda(expression.getLeft(), expression.getArguments(), (Expression)expression.getExpression().accept((ExpressionVisitor)this, data));
    }

    public Expression visit(ParameterToken parameterToken, List<Problem> data) {
        throw new UnresolvedExpressionParameterException(Collections.singletonList(parameterToken));
    }

    @Generated
    public AggregateExpressionRealizer(RealizationContext context, Type inputType, Expression root) {
        this.context = context;
        this.inputType = inputType;
        this.root = root;
    }
}

