/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.rl;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.rl.DefaultExpressionRealizer;
import nz.org.riskscape.engine.rl.ExpressionRealizer;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.ExpressionProblems;
import nz.org.riskscape.rl.ast.StructDeclaration;

class StructDeclarationRealizer {
    private final List<Problem> problems;
    private final Type inputType;
    private final RealizationContext context;
    private final BiFunction<Expression, Expression, DefaultExpressionRealizer.Realized> realizeCallback;

    static DefaultExpressionRealizer.Realized create(Type inputType, StructDeclaration sd, Struct resultType, List<RealizedStructMember> members) {
        RealizedStructMember[] memberArray = members.toArray(new RealizedStructMember[0]);
        BiFunction<DefaultExpressionRealizer.Realized, Object, Object> function = (re, input) -> {
            Tuple result = new Tuple(resultType);
            for (RealizedStructMember member : memberArray) {
                Object value = member.realized.evaluate(input);
                if (member.splat) {
                    if (value == null) continue;
                    result.setAll(member.index, (Tuple)value);
                    continue;
                }
                result.set(member.index, value);
            }
            return result;
        };
        List dependencies = members.stream().map(rsm -> rsm.realized).collect(Collectors.toList());
        return new DefaultExpressionRealizer.Realized(inputType, (Expression)sd, (Type)resultType, function, dependencies, null);
    }

    DefaultExpressionRealizer.Realized realize(StructDeclaration sd, Expression parent) {
        LinkedList<RealizedStructMember> members = new LinkedList<RealizedStructMember>();
        LinkedList<StructMemberElement> elements = new LinkedList<StructMemberElement>();
        this.realizeStructMembers(sd, parent, members, elements);
        Struct.StructBuilder builder = Struct.builder();
        for (StructMemberElement element : elements) {
            builder.add(element.name, element.type);
        }
        Struct resultType = this.context.normalizeStruct(builder.build());
        return StructDeclarationRealizer.create(this.inputType, sd, resultType, members);
    }

    private void realizeStructMembers(StructDeclaration sd, Expression parent, List<RealizedStructMember> members, List<StructMemberElement> elements) {
        for (StructDeclaration.Member member : sd.getMembers()) {
            int index;
            boolean splat;
            boolean bl = splat = member.isSelectAll() || member.isSelectAllOnReceiver();
            DefaultExpressionRealizer.Realized realized = this.realizeCallback.apply(member.getExpression(), (Expression)sd);
            if (realized.isFailed()) continue;
            if (member.isSelectAllOnReceiver() && !member.isAnonymous()) {
                this.problems.add(ExpressionProblems.get().pointlessSelectAllInStruct(member));
                continue;
            }
            if (splat) {
                index = elements.size();
                Struct splattedType = realized.getResultType().findAllowNull(Struct.class).orElse(null);
                if (splattedType == null) {
                    this.problems.add(ExpressionProblems.get().selectAllRequiresAStruct(member, realized.getResultType()));
                    continue;
                }
                boolean splattedWasNullable = Nullable.is((Type)realized.getResultType());
                for (Struct.StructMember splattedMember : splattedType.getMembers()) {
                    StructMemberElement newElement = new StructMemberElement(splattedMember.getKey(), Nullable.ifTrue((boolean)splattedWasNullable, (Type)splattedMember.getType()), member);
                    int existingIndex = elements.indexOf(newElement);
                    if (existingIndex != -1) {
                        StructMemberElement existingElement = elements.get(existingIndex);
                        this.problems.add(ExpressionProblems.get().canNotReplaceMember(splattedMember.getKey(), existingElement.expression, member));
                        continue;
                    }
                    elements.add(newElement);
                }
            } else {
                String name = member.getName().orElse(ExpressionRealizer.getImplicitName((RealizationContext)this.context, (RealizedExpression)realized, (Collection)Lists.transform(elements, el -> el.name)));
                StructMemberElement newElement = new StructMemberElement(name, realized.getResultType(), member);
                int existingIndex = elements.indexOf(newElement);
                if (existingIndex == -1) {
                    index = elements.size();
                    elements.add(newElement);
                } else {
                    StructMemberElement existingElement = elements.get(existingIndex);
                    if (existingElement.isSplat()) {
                        elements.set(existingIndex, newElement);
                        index = existingIndex;
                    } else {
                        this.problems.add(ExpressionProblems.get().canNotReplaceMember(name, existingElement.expression, member));
                        continue;
                    }
                }
            }
            members.add(new RealizedStructMember(realized, splat, index));
        }
    }

    @Generated
    public StructDeclarationRealizer(List<Problem> problems, Type inputType, RealizationContext context, BiFunction<Expression, Expression, DefaultExpressionRealizer.Realized> realizeCallback) {
        this.problems = problems;
        this.inputType = inputType;
        this.context = context;
        this.realizeCallback = realizeCallback;
    }

    private static final class RealizedStructMember {
        final DefaultExpressionRealizer.Realized realized;
        final boolean splat;
        final int index;

        @Generated
        public RealizedStructMember(DefaultExpressionRealizer.Realized realized, boolean splat, int index) {
            this.realized = realized;
            this.splat = splat;
            this.index = index;
        }

        @Generated
        public String toString() {
            return "StructDeclarationRealizer.RealizedStructMember(realized=" + String.valueOf(this.realized) + ", splat=" + this.splat + ", index=" + this.index + ")";
        }
    }

    private static final class StructMemberElement {
        final String name;
        final Type type;
        final StructDeclaration.Member expression;

        public boolean isSplat() {
            return this.expression.isSelectAll() || this.expression.isSelectAllOnReceiver();
        }

        @Generated
        public StructMemberElement(String name, Type type, StructDeclaration.Member expression) {
            this.name = name;
            this.type = type;
            this.expression = expression;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StructMemberElement)) {
                return false;
            }
            StructMemberElement other = (StructMemberElement)o;
            String this$name = this.name;
            String other$name = other.name;
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.name;
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "StructDeclarationRealizer.StructMemberElement(name=" + this.name + ", type=" + String.valueOf(this.type) + ", expression=" + String.valueOf(this.expression) + ")";
        }
    }
}

