/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.rl;

import lombok.Generated;
import nz.org.riskscape.dsl.Token;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.rl.ast.Lambda;

public class ScopedLambdaExpression {
    private final Lambda expression;
    private final Tuple scope;

    public Tuple buildCallingScope(Struct newScopeType, Object ... lambdaValues) {
        Tuple newScope = new Tuple(newScopeType);
        newScope.setAll(this.scope);
        for (int i = 0; i < lambdaValues.length; ++i) {
            String lambdaArgName = ((Token)this.expression.getArguments().get(i)).getValue();
            Struct.StructMember itemInScope = newScopeType.getEntry(lambdaArgName);
            newScope.set(itemInScope, lambdaValues[i]);
        }
        return newScope;
    }

    @Generated
    public ScopedLambdaExpression(Lambda expression, Tuple scope) {
        this.expression = expression;
        this.scope = scope;
    }

    @Generated
    public Lambda getExpression() {
        return this.expression;
    }

    @Generated
    public Tuple getScope() {
        return this.scope;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScopedLambdaExpression)) {
            return false;
        }
        ScopedLambdaExpression other = (ScopedLambdaExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Lambda this$expression = this.getExpression();
        Lambda other$expression = other.getExpression();
        if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
            return false;
        }
        Tuple this$scope = this.getScope();
        Tuple other$scope = other.getScope();
        return !(this$scope == null ? other$scope != null : !this$scope.equals(other$scope));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ScopedLambdaExpression;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Lambda $expression = this.getExpression();
        result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
        Tuple $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ScopedLambdaExpression(expression=" + String.valueOf(this.getExpression()) + ", scope=" + String.valueOf(this.getScope()) + ")";
    }
}

