/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.rl;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.function.IdentifiedFunction;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.rl.ast.FunctionCall;

public class MissingFunctionException
extends RiskscapeException {
    private FunctionCall expression;
    private List<Type> argumentTypes;

    public MissingFunctionException(FunctionCall expression) {
        super("Could not find function with id " + expression.getIdentifier().getValue());
        this.expression = expression;
    }

    public MissingFunctionException(FunctionCall expression, List<Type> argumentTypes) {
        this(expression, argumentTypes, null);
    }

    public MissingFunctionException(FunctionCall expr, List<Type> argumentTypes, IdentifiedFunction byId) {
        super("Could not find function " + expr.getIdentifier().getValue() + " with arguments " + String.valueOf(argumentTypes) + MissingFunctionException.messageFor(Optional.ofNullable(byId)));
        this.expression = expr;
        this.argumentTypes = argumentTypes;
    }

    private static String messageFor(Optional<IdentifiedFunction> byId) {
        return byId.map(f -> " - function '" + f.getId() + "' only supports arguments " + String.valueOf(f.getArgumentTypes())).orElse("");
    }

    @Generated
    public FunctionCall getExpression() {
        return this.expression;
    }

    @Generated
    public List<Type> getArgumentTypes() {
        return this.argumentTypes;
    }
}

