/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.rl;

import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.BinaryFunction;
import nz.org.riskscape.engine.function.ConstantFunction;
import nz.org.riskscape.engine.function.ExpressionAggregationFunction;
import nz.org.riskscape.engine.function.FunctionArgument;
import nz.org.riskscape.engine.function.IdentifiedFunction;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.function.UnaryFunction;
import nz.org.riskscape.engine.function.agg.AggregationFunctionAdapter;
import nz.org.riskscape.engine.function.maths.Abs;
import nz.org.riskscape.engine.function.maths.Log;
import nz.org.riskscape.engine.function.maths.Log10;
import nz.org.riskscape.engine.function.maths.LogNormalCurveFunction;
import nz.org.riskscape.engine.function.maths.Max;
import nz.org.riskscape.engine.function.maths.Min;
import nz.org.riskscape.engine.function.maths.NormalCurveFunction;
import nz.org.riskscape.engine.function.maths.Polynomial;
import nz.org.riskscape.engine.function.maths.Pow;
import nz.org.riskscape.engine.function.maths.RandomChoice;
import nz.org.riskscape.engine.function.maths.RandomNorm;
import nz.org.riskscape.engine.function.maths.RandomUniform;
import nz.org.riskscape.engine.function.maths.Round;
import nz.org.riskscape.engine.function.maths.Scale;
import nz.org.riskscape.engine.rl.agg.AggregationFunction;
import nz.org.riskscape.engine.rl.agg.MedianAggregationFunction;
import nz.org.riskscape.engine.rl.agg.ModeAggregationFunction;
import nz.org.riskscape.engine.rl.agg.PercentileAggregationFunction;
import nz.org.riskscape.engine.rl.agg.StandardDeviationAggregationFunction;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;

public class MathsFunctions {
    public static final List<IdentifiedFunction> FUNCTIONS = Arrays.asList(new Pow(), new Log(), new Log10(), new UnaryFunction((Type)Types.FLOATING, (Type)Types.FLOATING, d -> Math.exp(d)).builtin("exp", IdentifiedFunction.Category.MATHS), new UnaryFunction((Type)Types.FLOATING, (Type)Types.FLOATING, d -> Math.sqrt(d)).identified("square_root", "Get the square root of the given number", RiskscapeFunction.BUILT_IN, IdentifiedFunction.Category.MATHS), new Abs(), new Min(), new Max(), new Round().builtin("round", IdentifiedFunction.Category.MATHS), new UnaryFunction((Type)Types.FLOATING, (Type)Types.INTEGER, d -> (long)Math.ceil(d)).identified("ceil", "Round number up to the closest integer", RiskscapeFunction.BUILT_IN, IdentifiedFunction.Category.MATHS), new UnaryFunction((Type)Types.FLOATING, (Type)Types.INTEGER, d -> (long)Math.floor(d)).identified("floor", "Round number down to the closest integer", RiskscapeFunction.BUILT_IN, IdentifiedFunction.Category.MATHS), new UnaryFunction((Type)Types.ANYTHING, (Type)Types.FLOATING, a -> Types.FLOATING.coerce(a)).identified("float", "Convert input to a 64 bit floating point number", RiskscapeFunction.BUILT_IN, IdentifiedFunction.Category.MATHS), new UnaryFunction((Type)Types.ANYTHING, (Type)Types.SMALLFLOAT, a -> Types.SMALLFLOAT.coerce(a)).identified("smallfloat", "Convert input to a small (32 bit) floating point number", RiskscapeFunction.BUILT_IN, IdentifiedFunction.Category.MATHS), new UnaryFunction((Type)Types.ANYTHING, (Type)Types.INTEGER, a -> Math.round((Double)Types.FLOATING.coerce(a))).identified("int", "Convert input to a integer number", RiskscapeFunction.BUILT_IN, IdentifiedFunction.Category.MATHS), ConstantFunction.returning((Object)Long.MAX_VALUE).builtin("maxint", IdentifiedFunction.Category.MATHS), ConstantFunction.returning((Object)Long.MIN_VALUE).builtin("minint", IdentifiedFunction.Category.MATHS), ConstantFunction.returning((Object)Double.MAX_VALUE).builtin("maxfloat", IdentifiedFunction.Category.MATHS), ConstantFunction.returning((Object)-1.7976931348623157E308).builtin("minfloat", IdentifiedFunction.Category.MATHS), ConstantFunction.returning((Object)Float.valueOf(Float.MAX_VALUE)).builtin("maxsmallfloat", IdentifiedFunction.Category.MATHS), ConstantFunction.returning((Object)Float.valueOf(Float.MIN_VALUE)).builtin("minsmallfloat", IdentifiedFunction.Category.MATHS), ConstantFunction.returning((Object)Double.POSITIVE_INFINITY).builtin("inf", IdentifiedFunction.Category.MATHS), ConstantFunction.returning((Object)Double.NEGATIVE_INFINITY).builtin("negative_inf", IdentifiedFunction.Category.MATHS), new NormalCurveFunction("norm_cdf", (d, x) -> d.cumulativeProbability(x.doubleValue())), new NormalCurveFunction("norm_pdf", (d, x) -> d.density(x.doubleValue())), new NormalCurveFunction("norm_ppf", (d, x) -> d.inverseCumulativeProbability(x.doubleValue())), new LogNormalCurveFunction("lognorm_cdf", (d, x) -> d.cumulativeProbability(x.doubleValue())), new LogNormalCurveFunction("lognorm_pdf", (d, x) -> d.density(x.doubleValue())), new LogNormalCurveFunction("lognorm_ppf", (d, x) -> d.inverseCumulativeProbability(x.doubleValue())), new Polynomial(), new RandomUniform().builtin("random_uniform", IdentifiedFunction.Category.MATHS), new RandomNorm().builtin("random_norm", IdentifiedFunction.Category.MATHS), new BinaryFunction(new FunctionArgument("dividend", (Type)Types.FLOATING), new FunctionArgument("divisor", (Type)Types.FLOATING), (Type)Types.FLOATING, (dividend, divisor) -> dividend % divisor).builtin("modulo", IdentifiedFunction.Category.MATHS), new RandomChoice().builtin("random_choice", IdentifiedFunction.Category.MATHS), new Scale(), AggregationFunction.asFunction((AggregationFunction)ExpressionAggregationFunction.builder().map("value -> {count: 1, value: value}").reduce("(l, r) -> {count: l.count + r.count, value: l.value + r.value}").process("last -> last.value / last.count").build()).builtin("mean", IdentifiedFunction.Category.MATHS), AggregationFunction.asFunction((AggregationFunction)ExpressionAggregationFunction.builder().identity("0").map("v -> if_then_else(is_null(v) or v = false, 0, 1)").reduce("(l, r) -> l + r").build()).builtin("count", IdentifiedFunction.Category.MATHS), AggregationFunction.asFunction((AggregationFunction)ExpressionAggregationFunction.builder().reduce("(l, r) -> l + r").build()).builtin("sum", IdentifiedFunction.Category.MATHS), AggregationFunction.asFunction((AggregationFunction)new MedianAggregationFunction()).builtin("median", IdentifiedFunction.Category.MATHS), AggregationFunction.asFunction((AggregationFunction)new ModeAggregationFunction()).builtin("mode", IdentifiedFunction.Category.MATHS), new AggregationFunctionAdapter(new PercentileAggregationFunction()){
        private final ArgumentList arguments = ArgumentList.create((String)"items", (Type)RSList.LIST_ANYTHING, (String)"percentiles", (Type)RSList.create((Type)Types.INTEGER));

        public List<Type> getArgumentTypes() {
            return this.getArguments().getArgumentTypes();
        }

        @Generated
        public ArgumentList getArguments() {
            return this.arguments;
        }
    }.builtin("percentiles", IdentifiedFunction.Category.MATHS), new AggregationFunctionAdapter(new PercentileAggregationFunction.Single()){
        private final ArgumentList arguments = ArgumentList.create((String)"items", (Type)RSList.LIST_ANYTHING, (String)"percentile", (Type)Types.INTEGER);

        public List<Type> getArgumentTypes() {
            return this.getArguments().getArgumentTypes();
        }

        @Generated
        public ArgumentList getArguments() {
            return this.arguments;
        }
    }.builtin("percentile", IdentifiedFunction.Category.MATHS), AggregationFunction.asFunction((AggregationFunction)new StandardDeviationAggregationFunction()).builtin("stddev", IdentifiedFunction.Category.MATHS));
}

