/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.rl;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import lombok.Generated;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.BinaryFunction;
import nz.org.riskscape.engine.function.CompositeAggregationFunction;
import nz.org.riskscape.engine.function.FunctionArgument;
import nz.org.riskscape.engine.function.IdentifiedFunction;
import nz.org.riskscape.engine.function.agg.AggregationFunctionAdapter;
import nz.org.riskscape.engine.function.lang.AppendList;
import nz.org.riskscape.engine.function.lang.AssertNotNull;
import nz.org.riskscape.engine.function.lang.ConcatList;
import nz.org.riskscape.engine.function.lang.FilterList;
import nz.org.riskscape.engine.function.lang.ListLength;
import nz.org.riskscape.engine.function.lang.MapList;
import nz.org.riskscape.engine.function.lang.NullOf;
import nz.org.riskscape.engine.function.lang.ZipLists;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.problem.SeverityLevel;
import nz.org.riskscape.engine.rl.GetAttribute;
import nz.org.riskscape.engine.rl.RealizableFunction;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;

public class LanguageFunctions {
    public static final LocalProblems PROBLEMS = (LocalProblems)Problems.get(LocalProblems.class);
    public static final IdentifiedFunction APPEND = new AppendList().builtin("append", IdentifiedFunction.Category.LANGUAGE);
    public static final IdentifiedFunction CONCAT = new ConcatList().builtin("concat", IdentifiedFunction.Category.LANGUAGE);
    public static final IdentifiedFunction MAP = new MapList().builtin("map", IdentifiedFunction.Category.LANGUAGE);
    public static final IdentifiedFunction FILTER = new FilterList().builtin("filter", IdentifiedFunction.Category.LANGUAGE);
    public static final IdentifiedFunction ZIP = new ZipLists().builtin("zip", IdentifiedFunction.Category.LANGUAGE);
    public static final IdentifiedFunction LENGTH = new ListLength().builtin("length", IdentifiedFunction.Category.LANGUAGE);
    public static final IdentifiedFunction NULL_OF = new NullOf().builtin("null_of", IdentifiedFunction.Category.LANGUAGE);
    public static final IdentifiedFunction GET_ATTR = new GetAttribute().builtin("get_attr", IdentifiedFunction.Category.LANGUAGE);
    public static final IdentifiedFunction ASSERT_NOT_NULL = new AssertNotNull().builtin("assert_not_null", IdentifiedFunction.Category.LANGUAGE);
    public static final IdentifiedFunction ASSERT = RealizableFunction.contextOnly((ArgumentList)ArgumentList.create((String)"condition", (Type)Types.BOOLEAN, (String)"message", (Type)Types.TEXT), (Type)Types.NOTHING, context -> args -> {
        boolean condition = (Boolean)args.get(0);
        if (!condition) {
            String message = (String)args.get(1);
            throw new RiskscapeException((Problems)PROBLEMS.userAssert(message));
        }
        return null;
    }).builtin("assert", IdentifiedFunction.Category.LANGUAGE);
    public static final IdentifiedFunction WARNING = RealizableFunction.contextOnly((ArgumentList)ArgumentList.create((String)"when", (Type)Types.BOOLEAN, (String)"message", (Type)Types.TEXT), (Type)Nullable.TEXT, context -> args -> {
        boolean when = (Boolean)args.get(0);
        if (when) {
            String message = (String)args.get(1);
            context.getProblemSink().accept(PROBLEMS.userWarning(message));
            return message;
        }
        return null;
    }).builtin("warning", IdentifiedFunction.Category.LANGUAGE);
    public static final List<IdentifiedFunction> FUNCTIONS = Arrays.asList(APPEND, CONCAT, MAP, FILTER, ZIP, LENGTH, new BinaryFunction(new FunctionArgument("start", (Type)Types.INTEGER), new FunctionArgument("stop", (Type)Types.INTEGER), (Type)RSList.create((Type)Types.INTEGER), (start, stop) -> LongStream.range(start, stop).mapToObj(Long::valueOf).collect(Collectors.toList())).builtin("range", IdentifiedFunction.Category.LANGUAGE), new AggregationFunctionAdapter(new CompositeAggregationFunction()){
        private final ArgumentList arguments = ArgumentList.create((String)"items", (Type)RSList.LIST_ANYTHING, (String)"aggregation", (Type)Types.ANYTHING);

        public List<Type> getArgumentTypes() {
            return this.getArguments().getArgumentTypes();
        }

        @Generated
        public ArgumentList getArguments() {
            return this.arguments;
        }
    }.builtin("aggregate_struct", IdentifiedFunction.Category.LANGUAGE), NULL_OF, ASSERT_NOT_NULL, ASSERT, WARNING);

    public static interface LocalProblems
    extends ProblemFactory {
        @SeverityLevel(value=Problem.Severity.WARNING)
        public Problem userWarning(String var1);

        public Problem userAssert(String var1);
    }
}

