/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.rl;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.function.IdentifiedFunction;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.rl.RealizableFunction;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.FunctionCall;

public class IsNull
implements IdentifiedFunction,
RealizableFunction {
    public Object call(List<Object> args) {
        throw new UnsupportedOperationException("this function is not meant to be used directly");
    }

    public List<Type> getArgumentTypes() {
        return Arrays.asList(Nullable.ANYTHING);
    }

    public Type getReturnType() {
        return Types.BOOLEAN;
    }

    public String getId() {
        return "is_null";
    }

    public String getDescription() {
        return "Returns true if the given argument is null, as per https://docs.geoserver.org/latest/en/user/filter/function_reference.html#comparison-functions";
    }

    public IdentifiedFunction.Category getCategory() {
        return IdentifiedFunction.Category.LOGICAL;
    }

    public URI getSourceURI() {
        return RiskscapeFunction.BUILT_IN;
    }

    public ResultOrProblems<RiskscapeFunction> realize(RealizationContext context, FunctionCall functionCall, List<Type> arguments) {
        if (arguments.size() != 1) {
            return ResultOrProblems.failed((Problem[])new Problem[]{((ArgsProblems)Problems.get(ArgsProblems.class)).wrongNumber(this.getArgumentTypes().size(), arguments.size())});
        }
        return ResultOrProblems.of((Object)new Realized(arguments, (Type)Types.BOOLEAN));
    }

    private class Realized
    implements RiskscapeFunction {
        private final List<Type> argumentTypes;
        private final Type returnType;

        public Object call(List<Object> args) {
            return args.get(0) == null;
        }

        @Generated
        public Realized(List<Type> argumentTypes, Type returnType) {
            this.argumentTypes = argumentTypes;
            this.returnType = returnType;
        }

        @Generated
        public List<Type> getArgumentTypes() {
            return this.argumentTypes;
        }

        @Generated
        public Type getReturnType() {
            return this.returnType;
        }
    }
}

