/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.rl;

import java.util.List;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.FunctionArgument;
import nz.org.riskscape.engine.function.FunctionMetadata;
import nz.org.riskscape.engine.function.IdentifiedFunction;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.function.UntypedFunction;
import nz.org.riskscape.engine.rl.RealizableFunction;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.rl.ScopedLambdaExpression;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.ScopedLambdaType;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.engine.types.eqrule.Coercer;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.ExpressionProblems;
import nz.org.riskscape.rl.ast.FunctionCall;
import nz.org.riskscape.rl.ast.Lambda;

public class IfThenElse
implements RealizableFunction {
    public static final ArgumentList ARGUMENTS = ArgumentList.create((String)"condition", (Type)Nullable.BOOLEAN, (String)"then", (Type)Nullable.ANYTHING, (String)"else", (Type)Nullable.ANYTHING);
    public static final IdentifiedFunction IF = IfThenElse.asFunction("if", "");
    public static final IdentifiedFunction IF_THEN_ELSE = IfThenElse.asFunction("if_then_else", "");

    private static IdentifiedFunction asFunction(String id, String description) {
        FunctionMetadata metadata = new FunctionMetadata(id, ARGUMENTS, (Type)Types.ANYTHING, description, IdentifiedFunction.Category.LOGICAL, RiskscapeFunction.BUILT_IN);
        return RealizableFunction.identified((RealizableFunction)new IfThenElse(), (FunctionMetadata)metadata);
    }

    public ResultOrProblems<RiskscapeFunction> realize(RealizationContext context, FunctionCall functionCall, List<Type> givenTypes) {
        if (givenTypes.size() < 2 || givenTypes.size() > ARGUMENTS.size()) {
            return ResultOrProblems.failed((Problem[])new Problem[]{((ArgsProblems)Problems.get(ArgsProblems.class)).wrongNumberRange(2, ARGUMENTS.size(), givenTypes.size())});
        }
        return ProblemException.catching(() -> {
            Type returnType;
            ARGUMENTS.getRequiredArgument(functionCall, "condition").getOrThrow();
            ARGUMENTS.getRequiredArgument(functionCall, "then").getOrThrow();
            Coercer testCoercer = (Coercer)context.getTypeSet().findEquivalenceCoercer(Nullable.strip((Type)((Type)givenTypes.get(0))), (Type)Types.BOOLEAN).orElseThrow(() -> new ProblemException((Problems)ArgsProblems.mismatch((FunctionArgument)ARGUMENTS.get(0), (Type)((Type)givenTypes.get(0)))));
            RealizedExpression thenLambda = this.realizeLambdaExpressions((Type)givenTypes.get(1), (FunctionCall.Argument)functionCall.getArguments().get(1), context);
            Type thenType = thenLambda != null ? thenLambda.getResultType() : (Type)givenTypes.get(1);
            RealizedExpression elseLambda = null;
            if (givenTypes.size() == 2) {
                returnType = Nullable.of((Type)thenType);
            } else {
                elseLambda = this.realizeLambdaExpressions((Type)givenTypes.get(2), (FunctionCall.Argument)functionCall.getArguments().get(2), context);
                Type elseType = elseLambda != null ? elseLambda.getResultType() : (Type)givenTypes.get(2);
                returnType = context.getTypeSet().computeAncestorNoConversion(thenType, elseType);
            }
            return RiskscapeFunction.create((Object)this, (List)givenTypes, (Type)returnType, (UntypedFunction)this.buildFunction(testCoercer, thenLambda, elseLambda), (AutoCloseable[])new AutoCloseable[]{thenLambda, elseLambda});
        });
    }

    private RealizedExpression realizeLambdaExpressions(Type givenType, FunctionCall.Argument arg, RealizationContext context) throws ProblemException {
        ScopedLambdaType lambdaType = givenType.find(ScopedLambdaType.class).orElse(null);
        if (lambdaType == null) {
            return null;
        }
        if (lambdaType.getArity() != 0) {
            throw new ProblemException((Problems)ExpressionProblems.get().lambdaArityError(arg.getExpression(), lambdaType.getArity(), 0));
        }
        Lambda lambda = (Lambda)arg.getExpression();
        return (RealizedExpression)context.getExpressionRealizer().realize((Type)lambdaType.getScopeType(), lambda.getExpression()).getOrThrow();
    }

    private UntypedFunction buildFunction(Coercer testCoercer, RealizedExpression thenLambda, RealizedExpression elseLambda) {
        return args -> {
            Object condition = args.get(0);
            if (condition != null && testCoercer.apply(condition).equals(Boolean.TRUE)) {
                if (thenLambda == null) {
                    return args.get(1);
                }
                ScopedLambdaExpression givenLambda = (ScopedLambdaExpression)args.get(1);
                return thenLambda.evaluate((Object)givenLambda.getScope());
            }
            if (args.size() == 2) {
                return null;
            }
            if (elseLambda == null) {
                return args.get(2);
            }
            ScopedLambdaExpression givenLambda = (ScopedLambdaExpression)args.get(2);
            return elseLambda.evaluate((Object)givenLambda.getScope());
        };
    }
}

