/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.rl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Function;
import javax.measure.Unit;
import javax.measure.quantity.Area;
import javax.measure.quantity.Length;
import lombok.Generated;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.GeometryProblems;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.filter.FilterFactory;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.FunctionArgument;
import nz.org.riskscape.engine.function.GeometryPredicateFunction;
import nz.org.riskscape.engine.function.IdentifiedFunction;
import nz.org.riskscape.engine.function.JavaFunction;
import nz.org.riskscape.engine.function.geometry.Bounds;
import nz.org.riskscape.engine.function.geometry.Buffer;
import nz.org.riskscape.engine.function.geometry.CentroidFunction;
import nz.org.riskscape.engine.function.geometry.CreatePoint;
import nz.org.riskscape.engine.function.geometry.GeomFromWKT;
import nz.org.riskscape.engine.function.geometry.Reproject;
import nz.org.riskscape.engine.function.geometry.ToTypedCoverage;
import nz.org.riskscape.engine.geo.GeometryAreaOp;
import nz.org.riskscape.engine.geo.GeometryLengthOp;
import nz.org.riskscape.engine.geo.GeometryUtils;
import nz.org.riskscape.engine.geo.OverlayOperations;
import nz.org.riskscape.engine.rl.RealizableFunction;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.Floating;
import nz.org.riskscape.engine.types.Text;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.rl.ast.FunctionCall;
import org.geotools.measure.Units;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.IntersectionMatrix;
import org.locationtech.jts.geom.Lineal;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.Puntal;

public class GeometryFunctions {
    public static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();
    public static final FilterFactory FILTER_FACTORY = new FilterFactory();
    public static final OverlayOperations OVERLAY_OPERATIONS = OverlayOperations.get();
    public final List<IdentifiedFunction> functions;
    private final List<IdentifiedFunction> predicates;
    public static final IdentifiedFunction RELATE = new GeometryPredicateFunction(new FunctionArgument[]{new FunctionArgument("pattern", (Type)Types.TEXT)}){

        @Override
        protected Function<List<Object>, BiPredicate<Geometry, Geometry>> realizePredicateSupplier(RealizationContext context, FunctionCall functionCall, List<Type> argTypes) throws ProblemException {
            if (!argTypes.get(2).findAllowNull(Text.class).isPresent()) {
                throw new ProblemException((Problems)ArgsProblems.mismatch((FunctionArgument)this.arguments.get(2), (Type)argTypes.get(2)));
            }
            return args -> {
                String pattern = args.get(2).toString();
                return (lhs, rhs) -> {
                    IntersectionMatrix matrix = lhs.relate(rhs);
                    return matrix.matches(pattern);
                };
            };
        }
    }.builtin("relate", IdentifiedFunction.Category.GEOMETRY_LOGICAL);
    public final IdentifiedFunction dwithin = this.withinPredicateFunction(within -> within).builtin("dwithin", IdentifiedFunction.Category.GEOMETRY_LOGICAL);
    public final IdentifiedFunction beyond = this.withinPredicateFunction(within -> within == false).builtin("beyond", IdentifiedFunction.Category.GEOMETRY_LOGICAL);
    public static final IdentifiedFunction BBOX = JavaFunction.asBuiltin((String)"bbox", (IdentifiedFunction.Category)IdentifiedFunction.Category.GEOMETRY_LOGICAL).withArgumentTypes(Arrays.asList(Types.GEOMETRY, Types.FLOATING, Types.FLOATING, Types.FLOATING, Types.FLOATING)).withReturnType((Type)Types.BOOLEAN).calling(args -> {
        Geometry lhs = (Geometry)args.get(0);
        Double minx = (Double)args.get(1);
        Double miny = (Double)args.get(2);
        Double maxx = (Double)args.get(3);
        Double maxy = (Double)args.get(4);
        Envelope env = new Envelope(minx.doubleValue(), maxx.doubleValue(), miny.doubleValue(), maxy.doubleValue());
        return env.intersects(lhs.getEnvelopeInternal());
    });
    public static final IdentifiedFunction CENTROID = new CentroidFunction().builtin("centroid", IdentifiedFunction.Category.GEOMETRY_PROCESSING);
    public static final IdentifiedFunction INTERSECTION = JavaFunction.asBuiltin((String)"intersection", (IdentifiedFunction.Category)IdentifiedFunction.Category.GEOMETRY_PROCESSING).withArgumentTypes(Arrays.asList(Types.GEOMETRY, Types.GEOMETRY)).withReturnType((Type)Types.GEOMETRY).calling(args -> {
        Geometry lhs = (Geometry)args.get(0);
        Geometry rhs = (Geometry)args.get(1);
        return OVERLAY_OPERATIONS.intersection(lhs, rhs);
    });
    public final IdentifiedFunction toCoverage = new ToTypedCoverage().builtin("to_coverage", IdentifiedFunction.Category.GEOMETRY_PROCESSING);
    public final IdentifiedFunction buffer = new Buffer().builtin("buffer", IdentifiedFunction.Category.GEOMETRY_PROCESSING);
    public final IdentifiedFunction length = RealizableFunction.contextOnly((ArgumentList)ArgumentList.create((String)"geom", (Type)Types.GEOMETRY), (Type)Types.FLOATING, context -> {
        GeometryLengthOp op = new GeometryLengthOp(context.getProject().getSridSet());
        return args -> {
            Geometry geom = (Geometry)args.get(0);
            return op.apply(geom, (Unit<Length>)Units.METRE);
        };
    }).builtin("measure_length", IdentifiedFunction.Category.GEOMETRY_PROCESSING);
    public final IdentifiedFunction area = RealizableFunction.contextOnly((ArgumentList)ArgumentList.create((String)"geom", (Type)Types.GEOMETRY), (Type)Types.FLOATING, context -> {
        GeometryAreaOp op = new GeometryAreaOp(context.getProject().getSridSet());
        return args -> {
            Geometry geom = (Geometry)args.get(0);
            return op.apply(geom, (Unit<Area>)tech.units.indriya.unit.Units.SQUARE_METRE);
        };
    }).builtin("measure_area", IdentifiedFunction.Category.GEOMETRY_PROCESSING);
    public final IdentifiedFunction measure = RealizableFunction.contextOnly((ArgumentList)ArgumentList.create((String)"geom", (Type)Types.GEOMETRY), (Type)Types.FLOATING, context -> {
        GeometryLengthOp lengthOp = new GeometryLengthOp(context.getProject().getSridSet());
        GeometryAreaOp areaOp = new GeometryAreaOp(context.getProject().getSridSet());
        return args -> {
            Geometry geom = (Geometry)args.get(0);
            if (geom instanceof Polygonal) {
                return areaOp.apply(geom, (Unit<Area>)tech.units.indriya.unit.Units.SQUARE_METRE);
            }
            if (geom instanceof Lineal) {
                return lengthOp.apply(geom, (Unit<Length>)Units.METRE);
            }
            if (geom instanceof Puntal) {
                return 0.0;
            }
            HashSet geomTypes = new HashSet();
            GeometryUtils.processPerPart((Geometry)geom, part -> geomTypes.add(part.getClass().getSimpleName()));
            throw new RiskscapeException((Problems)GeometryProblems.get().mixedGeometryTypes(geomTypes));
        };
    }).builtin("measure", IdentifiedFunction.Category.GEOMETRY_PROCESSING);

    public GeometryFunctions(Engine engine) {
        this.functions = Arrays.asList(CENTROID, INTERSECTION, new Bounds().builtin("bounds", IdentifiedFunction.Category.GEOMETRY_PROCESSING), this.buffer, new CreatePoint(), new GeomFromWKT().builtin("geom_from_wkt", IdentifiedFunction.Category.GEOMETRY_PROCESSING), new Reproject().asFunction().builtin("reproject", IdentifiedFunction.Category.GEOMETRY_PROCESSING), this.area, this.length, this.measure, this.toCoverage);
        this.predicates = Arrays.asList(GeometryFunctions.newOne("intersects", (lhs, rhs) -> lhs.intersects(rhs)), GeometryFunctions.newOne("disjoint", (lhs, rhs) -> lhs.disjoint(rhs)), GeometryFunctions.newOne("contains", (lhs, rhs) -> lhs.contains(rhs)), GeometryFunctions.newOne("within", (lhs, rhs) -> lhs.within(rhs)), GeometryFunctions.newOne("touches", (lhs, rhs) -> lhs.touches(rhs)), GeometryFunctions.newOne("crosses", (lhs, rhs) -> lhs.crosses(rhs)), GeometryFunctions.newOne("overlaps", (lhs, rhs) -> lhs.overlaps(rhs)), GeometryFunctions.newOne("equals", (lhs, rhs) -> lhs.equalsTopo(rhs)), RELATE, this.dwithin, this.beyond, BBOX);
    }

    private GeometryPredicateFunction withinPredicateFunction(final Function<Boolean, Boolean> adaptor) {
        return new GeometryPredicateFunction(new FunctionArgument[]{new FunctionArgument("distance", (Type)Types.FLOATING)}){

            @Override
            protected Function<List<Object>, BiPredicate<Geometry, Geometry>> realizePredicateSupplier(RealizationContext context, FunctionCall functionCall, List<Type> argTypes) throws ProblemException {
                if (!argTypes.get(2).find(Floating.class).isPresent()) {
                    throw new ProblemException((Problems)ArgsProblems.mismatch((FunctionArgument)this.arguments.get(2), (Type)argTypes.get(2)));
                }
                return args -> {
                    Double distanceInput = (Double)args.get(2);
                    return (lhs, rhs) -> {
                        Double distance = GeometryFunctions.this.distanceToCrsUnits(distanceInput, (Geometry)rhs, context.getProject().getSridSet());
                        return (Boolean)adaptor.apply(lhs.isWithinDistance(rhs, distance.doubleValue()));
                    };
                };
            }
        };
    }

    private double distanceToCrsUnits(double distance, Geometry geom, SRIDSet sridSet) {
        return GeometryUtils.distanceToCrsUnits((double)distance, (Geometry)geom, (SRIDSet)sridSet);
    }

    private static IdentifiedFunction newOne(String identifier, BiPredicate<Geometry, Geometry> function) {
        return new GeometryPredicateFunction(function).builtin(identifier, IdentifiedFunction.Category.GEOMETRY_LOGICAL);
    }

    @Generated
    public List<IdentifiedFunction> getFunctions() {
        return this.functions;
    }

    @Generated
    public List<IdentifiedFunction> getPredicates() {
        return this.predicates;
    }
}

