/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.rl;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.dsl.Token;
import nz.org.riskscape.dsl.TokenType;
import nz.org.riskscape.rl.ExpressionParser;
import nz.org.riskscape.rl.TokenTypes;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.FunctionCall;

public class FunctionCallPrototype {
    private final FunctionCall prototype;
    private final List<FunctionCall.Argument> newArguments;

    public FunctionCallPrototype(FunctionCall prototype) {
        this.prototype = prototype;
        this.newArguments = Lists.newArrayList((Iterable)prototype.getArguments());
    }

    public FunctionCallPrototype setArgument(int i, String argFormat, Object ... formatArgs) {
        return this.setArgument(i, Optional.empty(), argFormat, formatArgs);
    }

    public FunctionCallPrototype setArgument(int i, Optional<String> argumentName, String argFormat, Object ... formatArgs) {
        Expression valueExpression = ExpressionParser.INSTANCE.parse(String.format(argFormat, formatArgs));
        FunctionCall.Argument newValueArg = new FunctionCall.Argument(valueExpression, argumentName.map(name -> Token.token((TokenType)TokenTypes.IDENTIFIER, (String)name)));
        if (this.newArguments.size() > i) {
            this.newArguments.set(i, newValueArg);
        } else if (this.newArguments.size() == i) {
            this.newArguments.add(newValueArg);
        } else {
            throw new IllegalArgumentException(String.format("Missing argument %d", i - 1));
        }
        return this;
    }

    public FunctionCallPrototype setFirstArgument(String argFormat, Object ... formatArgs) {
        return this.setArgument(0, argFormat, formatArgs);
    }

    public FunctionCallPrototype addArgument(Optional<String> argumentName, String argFormat, Object ... formatArgs) {
        return this.setArgument(this.newArguments.size(), argumentName, argFormat, formatArgs);
    }

    public FunctionCall build() {
        return new FunctionCall(this.prototype.getIdentifier(), this.newArguments);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FunctionCallPrototype)) {
            return false;
        }
        FunctionCallPrototype other = (FunctionCallPrototype)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FunctionCall this$prototype = this.getPrototype();
        FunctionCall other$prototype = other.getPrototype();
        if (this$prototype == null ? other$prototype != null : !this$prototype.equals(other$prototype)) {
            return false;
        }
        List<FunctionCall.Argument> this$newArguments = this.getNewArguments();
        List<FunctionCall.Argument> other$newArguments = other.getNewArguments();
        return !(this$newArguments == null ? other$newArguments != null : !((Object)this$newArguments).equals(other$newArguments));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FunctionCallPrototype;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FunctionCall $prototype = this.getPrototype();
        result = result * 59 + ($prototype == null ? 43 : $prototype.hashCode());
        List<FunctionCall.Argument> $newArguments = this.getNewArguments();
        result = result * 59 + ($newArguments == null ? 43 : ((Object)$newArguments).hashCode());
        return result;
    }

    @Generated
    public FunctionCall getPrototype() {
        return this.prototype;
    }

    @Generated
    public List<FunctionCall.Argument> getNewArguments() {
        return this.newArguments;
    }
}

