/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.rl;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import nz.org.riskscape.dsl.Token;
import nz.org.riskscape.engine.FailedObjectException;
import nz.org.riskscape.engine.NoSuchObjectException;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.expr.StructAccessExpression;
import nz.org.riskscape.engine.expr.StructMemberAccessExpression;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.FunctionArgument;
import nz.org.riskscape.engine.function.IdentifiedFunction;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.rl.EvalException;
import nz.org.riskscape.engine.rl.ExpressionRealizer;
import nz.org.riskscape.engine.rl.MissingFunctionException;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.rl.ScopedLambdaExpression;
import nz.org.riskscape.engine.rl.StructDeclarationRealizer;
import nz.org.riskscape.engine.rl.UnresolvedExpressionParameterException;
import nz.org.riskscape.engine.rl.agg.AggregateExpressionRealizer;
import nz.org.riskscape.engine.rl.agg.RealizedAggregateExpression;
import nz.org.riskscape.engine.types.EmptyList;
import nz.org.riskscape.engine.types.Integer;
import nz.org.riskscape.engine.types.LambdaType;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeProblems;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.engine.types.ancestor.AncestorTypeList;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemCode;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ExpressionParser;
import nz.org.riskscape.rl.TokenTypes;
import nz.org.riskscape.rl.ast.BinaryOperation;
import nz.org.riskscape.rl.ast.BracketedExpression;
import nz.org.riskscape.rl.ast.Constant;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.ExpressionProblems;
import nz.org.riskscape.rl.ast.FunctionCall;
import nz.org.riskscape.rl.ast.Lambda;
import nz.org.riskscape.rl.ast.ListDeclaration;
import nz.org.riskscape.rl.ast.ParameterToken;
import nz.org.riskscape.rl.ast.PropertyAccess;
import nz.org.riskscape.rl.ast.SelectAllExpression;
import nz.org.riskscape.rl.ast.StructDeclaration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExpressionRealizer
implements ExpressionRealizer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultExpressionRealizer.class);
    static final Realized MISSING_ARGUMENT = new Realized((Type)Types.NOTHING, ExpressionParser.INSTANCE.parse("[]"), (Type)Types.NOTHING, (r, in) -> null, false, Collections.emptyList(), null);
    private final ExpressionParser parser;
    private final RealizationContext realizationContext;

    public DefaultExpressionRealizer(@NonNull RealizationContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.realizationContext = context;
        this.parser = new ExpressionParser();
    }

    public RealizedExpression asStruct(RealizationContext context, RealizedExpression expression) {
        if (expression.getResultType() instanceof Struct) {
            return expression;
        }
        String memberName = ExpressionRealizer.getImplicitName((RealizationContext)context, (RealizedExpression)expression, Collections.emptyList());
        Struct struct = this.realizationContext.normalizeStruct(Struct.of((String)memberName, (Type)expression.getResultType()));
        return new StructConverter(struct, expression);
    }

    public ResultOrProblems<RealizedExpression> realize(Type inputType, String source) {
        return this.parser.parseOr(source).flatMap(expression -> new Instance(inputType, (Expression)expression, this.realizationContext).realize());
    }

    public ResultOrProblems<RealizedExpression> realize(Type inputType, Expression expression) {
        return new Instance(inputType, expression, this.realizationContext).realize();
    }

    public Expression parse(String source) {
        return this.parser.parse(source);
    }

    public ResultOrProblems<RealizedAggregateExpression> realizeAggregate(Type inputType, Expression expression) {
        return new AggregateExpressionRealizer(this.realizationContext, inputType, expression).realize();
    }

    @Generated
    public DefaultExpressionRealizer(ExpressionParser parser, RealizationContext realizationContext) {
        this.parser = parser;
        this.realizationContext = realizationContext;
    }

    private static class StructConverter
    implements RealizedExpression {
        private final Struct struct;
        private final RealizedExpression expr;

        public Type getResultType() {
            return this.struct;
        }

        public Type getInputType() {
            return this.expr.getInputType();
        }

        public Expression getExpression() {
            return this.expr.getExpression();
        }

        public List<RealizedExpression> getDependencies() {
            return Arrays.asList(this.expr);
        }

        public Object evaluate(Object input) {
            return Tuple.ofValues((Struct)this.struct, (Object[])new Object[]{this.expr.evaluate(input)});
        }

        @Generated
        public StructConverter(Struct struct, RealizedExpression expr) {
            this.struct = struct;
            this.expr = expr;
        }
    }

    private class Instance {
        private List<Problem> problems = new ArrayList<Problem>();
        private Type inputType;
        private Expression root;
        RealizationContext context;
        StructDeclarationRealizer structDeclRealizer;

        Instance(@NonNull Type inputType, @NonNull Expression root, RealizationContext context) {
            if (inputType == null) {
                throw new NullPointerException("inputType is marked non-null but is null");
            }
            if (root == null) {
                throw new NullPointerException("root is marked non-null but is null");
            }
            if (context == null) {
                throw new NullPointerException("context is marked non-null but is null");
            }
            this.inputType = inputType;
            this.root = root;
            this.context = context;
            this.structDeclRealizer = new StructDeclarationRealizer(this.problems, inputType, context, (e1, e2) -> this.realizeRaw((Expression)e1, (Expression)e2));
        }

        public ResultOrProblems<RealizedExpression> realize() {
            this.normalizeStruct(this.inputType);
            Realized realized = this.realizeRaw(this.root, this.root);
            if (Problem.hasErrors(this.problems)) {
                return ResultOrProblems.failed(this.problems);
            }
            return ResultOrProblems.of((Object)realized);
        }

        private void normalizeStruct(Type maybeAStruct) {
            maybeAStruct.findAllowNull(Struct.class).ifPresent(s -> {
                Struct normalized = this.context.normalizeStruct(s);
                if (normalized != s) {
                    log.debug("Input type for realization of {} did not normalize to itself.  This can lead to proliferation of identical struct types.", (Object)this.root);
                }
            });
        }

        private Realized realizeRaw(Expression expr, Expression parent) {
            return this.tryThese(expr, Arrays.asList(this.realizeIf(expr, BinaryOperation.class, fc -> this.realizeRaw((BinaryOperation)fc, parent)), this.realizeIf(expr, BracketedExpression.class, fc -> this.realizeRaw((BracketedExpression)fc, parent)), this.realizeIf(expr, FunctionCall.class, fc -> this.realizeRaw((FunctionCall)fc, parent)), this.realizeIf(expr, PropertyAccess.class, pa -> this.realizeRaw((PropertyAccess)pa, parent)), this.realizeIf(expr, Constant.class, c -> this.realizeRaw((Constant)c, parent)), this.realizeIf(expr, ListDeclaration.class, ld -> this.realizeRaw((ListDeclaration)ld, parent)), this.realizeIf(expr, StructDeclaration.class, sd -> this.realizeRaw((StructDeclaration)sd, parent)), this.realizeIf(expr, SelectAllExpression.class, se -> this.realizeRaw((SelectAllExpression)se, parent)), this.realizeIf(expr, Lambda.class, le -> this.realizeRaw((Lambda)le)), this.realizeIf(expr, ParameterToken.class, pt -> this.realizeRaw((ParameterToken)pt))));
        }

        private Realized realizeRaw(ListDeclaration ld, Expression parent) {
            ArrayList<Realized> realizedElements = new ArrayList<Realized>(ld.size());
            for (Expression element : ld.getElements()) {
                realizedElements.add(this.realizeRaw(element, (Expression)ld));
            }
            if (this.anyFailed(realizedElements)) {
                return Realized.failed(this.inputType, (Expression)ld);
            }
            List listElementTypes = realizedElements.stream().map(realized -> realized.getResultType()).collect(Collectors.toList());
            AncestorTypeList ancestorType = this.context.getProject().getTypeSet().computeAncestors(listElementTypes);
            EmptyList listType = ancestorType.getType() == Types.NOTHING ? EmptyList.INSTANCE : RSList.create((Type)ancestorType.getType());
            return new Realized(this.inputType, (Expression)ld, (Type)listType, (re, input) -> {
                ArrayList<Object> evaluated = new ArrayList<Object>(realizedElements.size());
                for (Realized element : realizedElements) {
                    evaluated.add(element.evaluate(input));
                }
                return ancestorType.getConverter().apply(evaluated);
            }, realizedElements, null);
        }

        private Realized realizeRaw(Constant c, Expression parent) {
            Object javaObject;
            Integer simpleType;
            Token token = c.getToken();
            switch ((TokenTypes)token.type) {
                case INTEGER: {
                    simpleType = Types.INTEGER;
                    javaObject = Long.parseLong(token.value);
                    break;
                }
                case DECIMAL: {
                    simpleType = Types.FLOATING;
                    javaObject = Double.parseDouble(token.value);
                    break;
                }
                case SCIENTIFIC_NOTATION: {
                    simpleType = Types.FLOATING;
                    javaObject = Double.valueOf(token.value);
                    break;
                }
                case STRING: {
                    simpleType = Types.TEXT;
                    javaObject = token.value;
                    break;
                }
                case KEYWORD_TRUE: {
                    simpleType = Types.BOOLEAN;
                    javaObject = Boolean.TRUE;
                    break;
                }
                case KEYWORD_FALSE: {
                    simpleType = Types.BOOLEAN;
                    javaObject = Boolean.FALSE;
                    break;
                }
                case KEYWORD_NULL: {
                    simpleType = Types.NOTHING;
                    javaObject = null;
                    break;
                }
                default: {
                    return this.failed((Expression)c, "unexpected constant token: " + String.valueOf(token));
                }
            }
            return new Realized(this.inputType, (Expression)c, (Type)simpleType, (x, y) -> javaObject, Collections.emptyList(), null);
        }

        private Realized failed(Expression failedOn, String message) {
            return this.failed(failedOn, message, Collections.emptyList());
        }

        private Realized failed(Expression failedOn, String message, List<Problem> causedBy) {
            if (causedBy.isEmpty()) {
                this.problems.add(Problem.error((String)"%s", (Object[])new Object[]{message}));
            } else {
                this.problems.add(Problem.composite(causedBy, (String)"%s", (Object[])new Object[]{message}));
            }
            return Realized.failed(this.inputType, failedOn);
        }

        private Realized realizeRaw(Lambda lambda) {
            return new Realized(this.inputType, (Expression)lambda, (Type)LambdaType.create((Lambda)lambda).scoped(this.inputType.asStruct()), (realized, input) -> new ScopedLambdaExpression(lambda, (Tuple)input), Collections.emptyList(), null);
        }

        private Realized realizeRaw(PropertyAccess access, Expression parent) {
            BiFunction<Realized, Object, Object> toUse;
            Type toBeEvaluated;
            Realized receiver;
            if (access.isTrailingSelectAll() && !parent.isA(StructDeclaration.class).isPresent()) {
                this.problems.add(ExpressionProblems.get().pointlessSelectAll(access));
                return Realized.failed(this.inputType, (Expression)access);
            }
            if (access.getReceiver().isPresent()) {
                receiver = this.realizeRaw((Expression)access.getReceiver().get(), (Expression)access);
                if (receiver.failed) {
                    return Realized.failed(this.inputType, (Expression)access);
                }
                toBeEvaluated = receiver.getResultType();
                toUse = (re, input) -> receiver.evaluate(input);
            } else {
                receiver = null;
                toBeEvaluated = this.inputType;
                toUse = (re, v) -> v;
            }
            boolean isNullable = Nullable.is((Type)toBeEvaluated);
            Struct structInput = toBeEvaluated.findAllowNull(Struct.class).orElse(null);
            if (structInput == null) {
                this.problems.add(((TypeProblems)Problems.get(TypeProblems.class)).notStruct((Expression)access, toBeEvaluated));
                return Realized.failed(this.inputType, (Expression)access);
            }
            if (access.isReceiverSelectAll()) {
                return new Realized(this.inputType, (Expression)access, receiver.resultType, (re, input) -> receiver.evaluate(input), Collections.singletonList(receiver), null);
            }
            StructAccessExpression sae = new StructAccessExpression(access.getIdentifiers().stream().filter(t -> t.type != TokenTypes.MULTIPLY).map(t -> t.value).collect(Collectors.toList()));
            ResultOrProblems<StructMemberAccessExpression> smae = sae.getExpressionFor(structInput);
            if (smae.hasProblems()) {
                this.problems.addAll(smae.getProblems());
                return Realized.failed(this.inputType, (Expression)access);
            }
            toUse = toUse.andThen(input -> input == null ? null : ((StructMemberAccessExpression)smae.get()).evaluate(input));
            return new Realized(this.inputType, (Expression)access, Nullable.ifTrue((boolean)isNullable, (Type)((StructMemberAccessExpression)smae.get()).getType()), toUse, receiver == null ? Collections.emptyList() : Collections.singletonList(receiver), null);
        }

        private Realized realizeRaw(FunctionCall fc, Expression parent) {
            IdentifiedFunction byId;
            List<Realized> unsortedArgs = fc.getArguments().stream().map(arg -> this.realizeRaw(arg.getExpression(), (Expression)fc)).collect(Collectors.toList());
            String functionId = fc.getIdentifier().value;
            try {
                byId = (IdentifiedFunction)this.context.getProject().getFunctionSet().get(functionId, this.context.getProblemSink());
            }
            catch (FailedObjectException ex) {
                this.problems.add(Problems.caught((Throwable)ex));
                return Realized.failed(this.inputType, (Expression)fc);
            }
            catch (NoSuchObjectException ex) {
                functionId = "geomFromWKT".equals(functionId) ? "geom_from_wkt" : CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, functionId);
                try {
                    byId = (IdentifiedFunction)this.context.getProject().getFunctionSet().get(functionId, this.context.getProblemSink());
                }
                catch (FailedObjectException | NoSuchObjectException ex2) {
                    this.problems.add(Problems.caught((Throwable)((Object)new MissingFunctionException(fc))));
                    if (ex2 instanceof FailedObjectException) {
                        log.warn("Likely internal function with id {} (after snake case conversion) was failed - pretending it does not exist", (Object)functionId, (Object)ex2);
                    }
                    return Realized.failed(this.inputType, (Expression)fc);
                }
            }
            if (byId == null) {
                this.problems.add(Problems.caught((Throwable)((Object)new MissingFunctionException(fc))));
                return Realized.failed(this.inputType, (Expression)fc);
            }
            List<Realized> realizedArgs = this.sort(unsortedArgs, fc, byId);
            if (realizedArgs == null) {
                return Realized.failed(this.inputType, (Expression)fc);
            }
            List argTypes = realizedArgs.stream().map(RealizedExpression::getResultType).collect(Collectors.toList());
            ResultOrProblems functionOr = this.context.getFunctionResolver().resolve(this.context, fc, this.inputType, argTypes, byId);
            if (functionOr.hasErrors()) {
                this.problems.addAll(functionOr.getProblems());
                return Realized.failed(this.inputType, (Expression)fc);
            }
            RiskscapeFunction function = (RiskscapeFunction)functionOr.get();
            return new Realized(this.inputType, (Expression)fc, function.getReturnType(), (re, input) -> {
                Object[] argValues = new Object[function.getArgumentTypes().size()];
                for (int idx = 0; idx < realizedArgs.size(); ++idx) {
                    try {
                        argValues[idx] = ((Realized)realizedArgs.get(idx)).evaluate(input);
                        continue;
                    }
                    catch (RuntimeException e) {
                        throw new EvalException("Failed to evaluate arg " + idx + " `" + re.getExpression().toSource() + "`", e, (RealizedExpression)re, input);
                    }
                }
                return function.call(Arrays.asList(argValues));
            }, realizedArgs, () -> function.close());
        }

        private Realized realizeRaw(BracketedExpression fc, Expression parent) {
            return this.realizeRaw(fc.getExpression(), (Expression)fc);
        }

        private Realized realizeRaw(BinaryOperation op, Expression parent) {
            ArrayList<LinkedBinaryOperation> binaryExpressions = new ArrayList<LinkedBinaryOperation>();
            this.unnestBinaryOperationChains(op, binaryExpressions, null);
            Collections.sort(binaryExpressions);
            Realized realized = null;
            for (LinkedBinaryOperation be : binaryExpressions) {
                Realized lhs = be.getPrevious() != null && be.getPrevious().getRealized() != null ? be.getPrevious().getRealized() : this.realizeRaw(be.getOperation().getLhs(), (Expression)op);
                Realized rhs = null;
                rhs = be.getNext() == null ? this.realizeRaw(be.getOperation().getRhs(), (Expression)op) : (be.getNext().getRealized() != null ? be.getNext().getRealized() : this.realizeRaw(be.getNext().getOperation().getLhs(), (Expression)op));
                realized = this.realizeRaw(new BinaryOperation(lhs.getExpression(), be.getOperation().getOperator(), rhs.getExpression()), lhs, rhs);
                if (realized.isFailed()) {
                    return realized;
                }
                be.setRealized(realized);
            }
            return realized;
        }

        private Realized realizeRaw(BinaryOperation op, Realized lhs, Realized rhs) {
            if (this.anyFailed(Arrays.asList(lhs, rhs))) {
                return Realized.failed(this.inputType, (Expression)op);
            }
            List<Type> argTypes = Arrays.asList(lhs.getResultType(), rhs.getResultType());
            RiskscapeFunction picked = this.context.getProject().getFunctionSet().resolve(this.context, op, this.inputType, lhs.getResultType(), rhs.getResultType()).orElse(null);
            if (picked == null) {
                this.problems.add(((ExpressionProblems)Problems.get(ExpressionProblems.class)).noSuchOperatorFunction(op.getOperator().value, argTypes));
                return Realized.failed(this.inputType, (Expression)op);
            }
            return new Realized(this.inputType, (Expression)op, picked.getReturnType(), (re, input) -> {
                List<Object> args = Arrays.asList(lhs.evaluate(input), rhs.evaluate(input));
                return picked.call(args);
            }, Arrays.asList(lhs, rhs), null);
        }

        private LinkedBinaryOperation unnestBinaryOperationChains(BinaryOperation target, List<LinkedBinaryOperation> linkedBinaryOperators, LinkedBinaryOperation previous) {
            LinkedBinaryOperation self = new LinkedBinaryOperation(target, previous);
            linkedBinaryOperators.add(self);
            if (target.getRhs() instanceof BinaryOperation) {
                self.setNext(this.unnestBinaryOperationChains((BinaryOperation)target.getRhs(), linkedBinaryOperators, self));
            }
            return self;
        }

        private Realized realizeRaw(StructDeclaration sd, Expression parent) {
            return this.structDeclRealizer.realize(sd, parent);
        }

        private Realized realizeRaw(SelectAllExpression expression, Expression parent) {
            return new Realized(this.inputType, (Expression)expression, this.inputType, (r, i) -> i, Collections.emptyList(), null);
        }

        private Realized realizeRaw(ParameterToken expression) {
            throw new UnresolvedExpressionParameterException(Collections.singletonList(expression));
        }

        private boolean anyFailed(Collection<Realized> realizedArgs) {
            for (Realized child : realizedArgs) {
                if (!child.isFailed()) continue;
                return true;
            }
            return false;
        }

        private List<Realized> sort(List<Realized> unsortedArgs, FunctionCall fc, IdentifiedFunction byId) {
            if (this.anyFailed(unsortedArgs)) {
                return null;
            }
            boolean hasErrors = false;
            if (!fc.hasKeywordArguments()) {
                return unsortedArgs;
            }
            ArgumentList al = byId.getArguments();
            int offset = fc.keywordArgumentsOffset();
            Realized[] sortedArgs = new Realized[Math.max(unsortedArgs.size(), byId.getArguments().size())];
            for (int i = 0; i < unsortedArgs.size(); ++i) {
                if (i < offset) {
                    sortedArgs[i] = unsortedArgs.get(i);
                    continue;
                }
                if (i >= fc.getArguments().size()) continue;
                FunctionCall.Argument arg = (FunctionCall.Argument)fc.getArguments().get(i);
                String keyword = arg.getName().orElse(null);
                if (keyword == null) {
                    this.problems.add(Problem.error((ProblemCode)ExpressionRealizer.ProblemCodes.KEYWORD_REQUIRED, (Object[])new Object[]{i + 1}));
                    hasErrors = true;
                    continue;
                }
                if (!al.hasArgument(keyword)) {
                    this.problems.add(Problem.error((ProblemCode)ExpressionRealizer.ProblemCodes.KEYWORD_DOES_NOT_EXIST, (Object[])new Object[]{keyword, al.getKeywords()}));
                    hasErrors = true;
                    continue;
                }
                FunctionArgument declared = al.get(keyword);
                if (declared.getIndex() >= sortedArgs.length) {
                    this.problems.add(Problem.error((ProblemCode)ExpressionRealizer.ProblemCodes.MISSING_KEYWORD_ARGUMENTS, (Object[])new Object[]{declared.getKeyword(), declared.getIndex() + 1, sortedArgs.length}));
                    hasErrors = true;
                    continue;
                }
                if (sortedArgs[declared.getIndex()] != null) {
                    int specifiedAs = unsortedArgs.indexOf(sortedArgs[declared.getIndex()]) + 1;
                    this.problems.add(Problem.error((ProblemCode)ExpressionRealizer.ProblemCodes.KEYWORD_OUT_OF_ORDER, (Object[])new Object[]{i + 1, declared.getKeyword(), specifiedAs}));
                    hasErrors = true;
                    continue;
                }
                sortedArgs[declared.getIndex()] = unsortedArgs.get(i);
            }
            if (hasErrors) {
                return null;
            }
            int idx = -1;
            int i = sortedArgs.length - 1;
            while (i >= 0 && sortedArgs[i] == null) {
                idx = i--;
            }
            if (idx > -1) {
                sortedArgs = Arrays.copyOf(sortedArgs, idx);
            }
            for (i = 0; i < sortedArgs.length; ++i) {
                if (sortedArgs[i] != null) continue;
                sortedArgs[i] = MISSING_ARGUMENT;
            }
            return Arrays.asList(sortedArgs);
        }

        private <T extends Expression> Optional<Realized> realizeIf(Expression expression, Class<T> ifType, Function<T, Realized> callback) {
            return expression.isA(ifType).map(callback);
        }

        public Realized tryThese(Expression expr, List<Optional<Realized>> optionals) {
            return optionals.stream().filter(Optional::isPresent).findFirst().map(Optional::get).orElseThrow(() -> new RuntimeException("Unrecognized expression type - " + String.valueOf(expr)));
        }
    }

    static final class Realized
    implements RealizedExpression {
        private final Type inputType;
        private final Expression expression;
        private final Type resultType;
        private final BiFunction<Realized, Object, Object> function;
        private final boolean failed;
        private final List<RealizedExpression> dependencies;
        private final Runnable closeFunction;

        static Realized failed(Type inputType, Expression failedOn) {
            return new Realized(inputType, failedOn, (Type)Types.ANYTHING, (r, in) -> new RiskscapeException("Can not evaluate a failed expression"), true, Collections.emptyList(), null);
        }

        Realized(Type inputType, Expression expr, Type resultType, BiFunction<Realized, Object, Object> function, List<? extends RealizedExpression> deps, Runnable closeFunction) {
            this.inputType = inputType;
            this.expression = expr;
            this.resultType = resultType;
            this.function = function;
            this.failed = false;
            this.dependencies = Lists.newArrayList(deps);
            this.closeFunction = closeFunction;
        }

        public Object evaluate(Object input) {
            try {
                return this.function.apply(this, input);
            }
            catch (RuntimeException e) {
                throw new EvalException(e, this, input);
            }
        }

        public void close() {
            super.close();
            if (this.closeFunction != null) {
                this.closeFunction.run();
            }
        }

        public String toString() {
            return String.format("Realized(expr=[%s] returns=%s)", this.expression.toSource(), this.resultType);
        }

        @Generated
        public Realized(Type inputType, Expression expression, Type resultType, BiFunction<Realized, Object, Object> function, boolean failed, List<RealizedExpression> dependencies, Runnable closeFunction) {
            this.inputType = inputType;
            this.expression = expression;
            this.resultType = resultType;
            this.function = function;
            this.failed = failed;
            this.dependencies = dependencies;
            this.closeFunction = closeFunction;
        }

        @Generated
        public Type getInputType() {
            return this.inputType;
        }

        @Generated
        public Expression getExpression() {
            return this.expression;
        }

        @Generated
        public Type getResultType() {
            return this.resultType;
        }

        @Generated
        public boolean isFailed() {
            return this.failed;
        }

        @Generated
        public List<RealizedExpression> getDependencies() {
            return this.dependencies;
        }
    }

    static final class LinkedBinaryOperation
    implements Comparable<LinkedBinaryOperation> {
        private final BinaryOperation operation;
        private final LinkedBinaryOperation previous;
        private LinkedBinaryOperation next;
        private Realized realized;

        LinkedBinaryOperation(BinaryOperation operation) {
            this.operation = operation;
            this.previous = null;
        }

        @Override
        public int compareTo(LinkedBinaryOperation o) {
            for (EnumSet level : BinaryOperation.PRIORITY) {
                if (level.contains(this.operation.getNormalizedOperator())) {
                    return level.contains(o.operation.getNormalizedOperator()) ? 0 : -1;
                }
                if (!level.contains(o.operation.getNormalizedOperator())) continue;
                return 1;
            }
            throw new RiskscapeException(String.format("Could not prioritise %s and %s", this.operation.getNormalizedOperator().toString(), o.operation.getNormalizedOperator().toString()));
        }

        public void setRealized(Realized realized) {
            this.realized = realized;
            LinkedBinaryOperation ascendant = this.previous;
            while (ascendant != null && ascendant.getRealized() != null) {
                ascendant.realized = realized;
                ascendant = ascendant.previous;
            }
            LinkedBinaryOperation descendant = this.next;
            while (descendant != null && descendant.getRealized() != null) {
                descendant.realized = realized;
                descendant = descendant.next;
            }
        }

        @Generated
        public LinkedBinaryOperation(BinaryOperation operation, LinkedBinaryOperation previous) {
            this.operation = operation;
            this.previous = previous;
        }

        @Generated
        public BinaryOperation getOperation() {
            return this.operation;
        }

        @Generated
        public LinkedBinaryOperation getPrevious() {
            return this.previous;
        }

        @Generated
        public LinkedBinaryOperation getNext() {
            return this.next;
        }

        @Generated
        public void setNext(LinkedBinaryOperation next) {
            this.next = next;
        }

        @Generated
        public Realized getRealized() {
            return this.realized;
        }
    }
}

