/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.rl;

import lombok.Generated;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.rl.ExpressionRealizer;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.TokenTypes;
import nz.org.riskscape.rl.ast.BinaryOperation;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.ExpressionConverter;
import nz.org.riskscape.rl.ast.ExpressionVisitor;
import nz.org.riskscape.rl.ast.PropertyAccess;

public class BooleanExpressionSplitter {
    public static ResultOrProblems<RealizedExpression> splitAndRealize(Expression expression, Struct inputType, ExpressionRealizer expressionRealizer) {
        try {
            Expression converted = (Expression)expression.accept(new Splitter(), (Object)new Data(inputType, expressionRealizer));
            if (converted != null) {
                return expressionRealizer.realize((Type)inputType, converted).flatMap(re -> {
                    if (Nullable.strip((Type)re.getResultType()) != Types.BOOLEAN) {
                        return ResultOrProblems.failed((Problem[])new Problem[]{Problem.error((String)"Expected %s from '%s' but found %s", (Object[])new Object[]{Types.BOOLEAN, expression.toSource(), re.getResultType()})});
                    }
                    return ResultOrProblems.of((Object)re);
                });
            }
        }
        catch (RiskscapeException riskscapeException) {
            // empty catch block
        }
        return ResultOrProblems.failed((Problem[])new Problem[]{Problem.error((String)"Could not apply '%s' to type %s", (Object[])new Object[]{expression.toSource(), inputType})});
    }

    private static class Splitter<T extends Data>
    extends ExpressionConverter<T> {
        private Splitter() {
        }

        public Expression visit(PropertyAccess expression, T data) {
            ResultOrProblems re = ((Data)data).expressionRealizer.realize((Type)((Data)data).inputType, (Expression)expression);
            if (re.hasErrors()) {
                throw new RiskscapeException(String.format("Could not apply '%s' to type %s", expression.toSource(), ((Data)data).inputType));
            }
            return expression;
        }

        public Expression visit(BinaryOperation expression, T data) {
            Expression rhs;
            Expression lhs;
            block7: {
                block6: {
                    lhs = null;
                    rhs = null;
                    try {
                        lhs = (Expression)expression.getLhs().accept((ExpressionVisitor)this, data);
                    }
                    catch (RiskscapeException e) {
                        if (expression.getOperator().type == TokenTypes.KEYWORD_AND) break block6;
                        throw e;
                    }
                }
                try {
                    rhs = (Expression)expression.getRhs().accept((ExpressionVisitor)this, data);
                }
                catch (RiskscapeException e) {
                    if (expression.getOperator().type == TokenTypes.KEYWORD_AND && lhs != null) break block7;
                    throw e;
                }
            }
            if (lhs != null && rhs != null) {
                return new BinaryOperation(lhs, expression.getOperator(), rhs);
            }
            if (lhs != null) {
                return lhs;
            }
            return rhs;
        }
    }

    private static class Data {
        final Struct inputType;
        final ExpressionRealizer expressionRealizer;

        @Generated
        public Data(Struct inputType, ExpressionRealizer expressionRealizer) {
            this.inputType = inputType;
            this.expressionRealizer = expressionRealizer;
        }
    }
}

