/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.restriction;

import java.util.List;
import java.util.function.Predicate;
import lombok.Generated;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.restriction.Restriction;
import nz.org.riskscape.engine.rl.ExpressionRealizer;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.Expression;

public class ExpressionRestriction
implements Restriction {
    private final Expression expression;
    private final ExpressionRealizer expressionRealizer;
    private ResultOrProblems<RealizedExpression> realizedRestriction;

    public Predicate<Tuple> getPredicate() {
        if (this.realizedRestriction == null || this.realizedRestriction.hasErrors()) {
            throw new RiskscapeException("Restriction has not been validated");
        }
        return t -> (Boolean)((RealizedExpression)this.realizedRestriction.get()).evaluate(t);
    }

    public List<Problem> validate(Struct type) {
        this.realizedRestriction = this.expressionRealizer.realize((Type)type, this.expression).flatMap(re -> {
            if (re.getResultType() != Types.BOOLEAN) {
                return ResultOrProblems.failed((Problem[])new Problem[]{Problem.error((String)"Expected %s but found %s", (Object[])new Object[]{Types.BOOLEAN, re.getResultType()})});
            }
            return ResultOrProblems.of((Object)re);
        });
        return this.realizedRestriction.getProblems();
    }

    @Generated
    public ExpressionRestriction(Expression expression, ExpressionRealizer expressionRealizer) {
        this.expression = expression;
        this.expressionRealizer = expressionRealizer;
    }

    @Generated
    public Expression getExpression() {
        return this.expression;
    }
}

