/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.resource;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import lombok.Generated;
import nz.org.riskscape.engine.resource.CreateException;
import nz.org.riskscape.engine.resource.CreateHandle;
import nz.org.riskscape.engine.resource.CreateRequest;

public class FileCreateHandle
extends CreateHandle {
    private final File writeTo;
    private final FileOutputStream outputStream;

    public FileCreateHandle(CreateRequest request, File writeTo) {
        super(request);
        this.writeTo = writeTo;
        try {
            this.outputStream = new FileOutputStream(writeTo);
        }
        catch (FileNotFoundException e) {
            throw new CreateException((Throwable)e);
        }
    }

    public URI store(CreateHandle.Callback callback) throws CreateException {
        try {
            callback.accept((OutputStream)this.outputStream);
            this.outputStream.close();
        }
        catch (IOException | RuntimeException e) {
            this.writeTo.delete();
            throw new CreateException((Throwable)e);
        }
        return this.writeTo.toURI();
    }

    public URI store() throws CreateException {
        try {
            this.outputStream.close();
        }
        catch (IOException e) {
            throw new CreateException((Throwable)e);
        }
        return this.writeTo.toURI();
    }

    @Generated
    public FileOutputStream getOutputStream() {
        return this.outputStream;
    }
}

