/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.resource;

import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import nz.org.riskscape.engine.resource.CreateException;
import nz.org.riskscape.engine.resource.CreateHandle;
import nz.org.riskscape.engine.resource.CreateRequest;
import nz.org.riskscape.engine.resource.FileCreateHandle;
import nz.org.riskscape.engine.resource.FileResourceLoader;
import nz.org.riskscape.engine.resource.Resource;
import nz.org.riskscape.engine.resource.ResourceFactory;
import nz.org.riskscape.engine.resource.ResourceLoader;
import nz.org.riskscape.engine.resource.ResourceLoadingException;
import nz.org.riskscape.engine.resource.ResourceProblems;
import nz.org.riskscape.engine.resource.UriHelper;
import nz.org.riskscape.problem.ResultOrProblems;

public class DefaultResourceFactory
implements ResourceFactory {
    private final List<ResourceLoader> loaders;

    public DefaultResourceFactory() {
        this(new FileResourceLoader());
    }

    public DefaultResourceFactory(ResourceLoader ... loaders) {
        this.loaders = Lists.newArrayList((Object[])loaders);
    }

    public Resource load(@NonNull String target, @NonNull URI relativeTo) throws ResourceLoadingException {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (relativeTo == null) {
            throw new NullPointerException("relativeTo is marked non-null but is null");
        }
        ResultOrProblems resourceUri = UriHelper.uriFromLocation((String)target, (URI)relativeTo);
        if (resourceUri.hasProblems()) {
            throw new ResourceLoadingException(relativeTo, resourceUri.getAsSingleProblem());
        }
        return this.load((URI)resourceUri.get());
    }

    public Resource load(@NonNull URI target, @NonNull URI relativeTo) throws ResourceLoadingException {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (relativeTo == null) {
            throw new NullPointerException("relativeTo is marked non-null but is null");
        }
        return this.load(relativeTo.resolve(target));
    }

    public Resource load(@NonNull URI target) throws ResourceLoadingException {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        for (ResourceLoader loader : this.loaders) {
            if (!loader.canLoad(target)) continue;
            return loader.load(target);
        }
        throw new ResourceLoadingException(target, String.format("Could not find a Resource Loader for '%s'", target.toString()));
    }

    public void add(ResourceLoader loader) {
        if (!this.loaders.contains(loader)) {
            this.loaders.add(loader);
        }
    }

    public CreateHandle create(CreateRequest request) {
        URI location = request.getContainer();
        if (location.getScheme().equals("file")) {
            File directory = new File(location.getPath());
            directory.mkdirs();
            if (!directory.canWrite() || !directory.isDirectory()) {
                throw new CreateException(ResourceProblems.get().containerNotWritable(location));
            }
            File file = new File(directory, request.getName());
            while (file.exists() && !request.isReplace()) {
                file = this.increment(file);
            }
            return new FileCreateHandle(request, file);
        }
        throw new CreateException(ResourceProblems.get().unsupportedScheme(location.getScheme()));
    }

    File increment(File file) {
        String filename = file.getName();
        String extension = Files.getFileExtension((String)filename);
        Object append = extension.length() == 0 ? "" : "." + extension;
        String basename = Files.getNameWithoutExtension((String)filename);
        Pattern pattern = Pattern.compile("(.+)-([0-9]+)$");
        Matcher matcher = pattern.matcher(basename);
        if (matcher.matches()) {
            int counter = Integer.parseInt(matcher.group(2)) + 1;
            return new File(file.getParentFile(), matcher.group(1) + "-" + counter + (String)append);
        }
        return new File(file.getParentFile(), basename + "-1" + (String)append);
    }

    @Generated
    public List<ResourceLoader> getLoaders() {
        return this.loaders;
    }
}

