/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.relation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.projection.FlatProjection;
import nz.org.riskscape.engine.projection.FlatProjector;
import nz.org.riskscape.engine.relation.Relation;
import nz.org.riskscape.engine.relation.TupleIterator;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.RelationType;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ResultOrProblems;

public class UnnestProjection
implements FlatProjection {
    private final List<String> members;
    private final Optional<String> indexKey;
    private final boolean emitEmpty;

    public UnnestProjection(List<String> members, Optional<String> indexKey, boolean emitEmpty) {
        this.members = members;
        this.indexKey = indexKey;
        this.emitEmpty = emitEmpty;
    }

    public ResultOrProblems<FlatProjector> getFlatProjector(Struct sourceType) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Struct.StructBuilder builder = new Struct.StructBuilder();
        ArrayList membersWip = Lists.newArrayList(this.members);
        boolean nullableMembers = this.members.size() > 1 || this.emitEmpty;
        for (Struct.StructMember sourceMember : sourceType.getMembers()) {
            if (membersWip.remove(sourceMember.getKey())) {
                Optional listOpt = sourceMember.getType().findAllowNull(RSList.class);
                RelationType relationType = sourceMember.getType().findAllowNull(RelationType.class).orElse(null);
                if (listOpt.isPresent()) {
                    Type listType = ((RSList)listOpt.get()).getMemberType();
                    if (nullableMembers) {
                        listType = Nullable.of((Type)listType);
                    }
                    builder.add(sourceMember.getKey(), listType);
                    continue;
                }
                if (relationType == null) {
                    problems.add(Problem.error((String)"Member '%s' is not a list type, was '%s'", (Object[])new Object[]{sourceMember.getKey(), sourceMember.getType()}));
                    continue;
                }
                builder.add(sourceMember.getKey(), Nullable.ifTrue((boolean)this.emitEmpty, (Type)relationType.getMemberType()));
                continue;
            }
            builder.add(sourceMember.getKey(), sourceMember.getType());
        }
        if (this.indexKey.isPresent()) {
            builder.add(this.indexKey.get(), (Type)Types.INTEGER);
        }
        if (!membersWip.isEmpty()) {
            problems.add(Problem.error((String)"Could not find members to unnest %s among %s", (Object[])new Object[]{membersWip, sourceType.getMemberKeys()}));
        }
        if (Problem.hasErrors(problems)) {
            return ResultOrProblems.failed(problems);
        }
        return builder.buildOr().composeProblems("Cannot create index-key '%s', member already present in %s", new Object[]{this.indexKey.orElse(""), sourceType}).map(projectedType -> new FlatProjectorImpl(sourceType, (Struct)projectedType, this.members, this.indexKey));
    }

    private class FlatProjectorImpl
    implements FlatProjector {
        private final Struct sourceType;
        private final Struct producedType;
        private final Struct.StructMember indexMember;
        private final Struct.StructMember[] sourceMembers;
        private final Struct.StructMember[] projectedMembers;

        FlatProjectorImpl(Struct sourceType, Struct projectedType, List<String> members, Optional<String> indexKey) {
            this.sourceType = sourceType;
            this.producedType = projectedType;
            this.sourceMembers = sourceType.getMembers().stream().filter(m -> members.contains(m.getKey())).collect(Collectors.toList()).toArray(new Struct.StructMember[0]);
            this.projectedMembers = projectedType.getMembers().stream().filter(m -> members.contains(m.getKey())).collect(Collectors.toList()).toArray(new Struct.StructMember[0]);
            this.indexMember = indexKey.map(key -> (Struct.StructMember)projectedType.getMember(key).get()).orElse(null);
        }

        public TupleIterator apply(Tuple tuple) {
            return new UnnestIterator(tuple);
        }

        @Generated
        public Struct getSourceType() {
            return this.sourceType;
        }

        @Generated
        public Struct getProducedType() {
            return this.producedType;
        }

        @Generated
        public Struct.StructMember getIndexMember() {
            return this.indexMember;
        }

        private class UnnestIterator
        implements TupleIterator {
            private final Iterator<?>[] values;
            private long index = 0L;
            private Tuple yielding;

            UnnestIterator(Tuple tuple) {
                this.values = new Iterator[FlatProjectorImpl.this.sourceMembers.length];
                for (int idx = 0; idx < FlatProjectorImpl.this.sourceMembers.length; ++idx) {
                    Object toUnnest = tuple.fetch(FlatProjectorImpl.this.sourceMembers[idx]);
                    if (toUnnest instanceof Relation) {
                        Relation relation = (Relation)toUnnest;
                        this.values[idx] = relation.iterator();
                    } else {
                        Collection coll = (Collection)tuple.fetch(FlatProjectorImpl.this.sourceMembers[idx]);
                        this.values[idx] = coll == null ? Collections.emptyIterator() : coll.iterator();
                    }
                    if (!UnnestProjection.this.emitEmpty) continue;
                    final Iterator<?> backingIterator = this.values[idx];
                    this.values[idx] = new Iterator(){
                        boolean first = true;

                        @Override
                        public boolean hasNext() {
                            return this.first || backingIterator.hasNext();
                        }

                        public Object next() {
                            this.first = false;
                            return backingIterator.hasNext() ? backingIterator.next() : null;
                        }
                    };
                }
                this.yielding = new Tuple(FlatProjectorImpl.this.producedType);
                this.yielding.setAll(tuple);
            }

            public boolean hasNext() {
                for (int idx = 0; idx < this.values.length; ++idx) {
                    if (!this.values[idx].hasNext()) continue;
                    return true;
                }
                return false;
            }

            public Tuple next() {
                ++this.index;
                for (int idx = 0; idx < FlatProjectorImpl.this.projectedMembers.length; ++idx) {
                    this.yielding.set(FlatProjectorImpl.this.projectedMembers[idx], this.values[idx].hasNext() ? this.values[idx].next() : null);
                }
                if (FlatProjectorImpl.this.indexMember != null) {
                    this.yielding.set(FlatProjectorImpl.this.indexMember, (Object)this.index);
                }
                return this.yielding.clone();
            }
        }
    }
}

