/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.relation;

import java.io.IOException;
import nz.org.riskscape.engine.RiskscapeIOException;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.io.TupleReader;
import nz.org.riskscape.engine.relation.BaseRelation;
import nz.org.riskscape.engine.relation.PeekingTupleIterator;
import nz.org.riskscape.engine.relation.RelationIOException;
import nz.org.riskscape.engine.relation.TupleIterator;
import nz.org.riskscape.engine.types.Struct;

public class TupleStorageRelation
extends BaseRelation {
    private ReaderSupplier supplier;

    public TupleStorageRelation(Struct type, ReaderSupplier supplier) {
        super(type);
        this.supplier = supplier;
    }

    protected TupleStorageRelation(BaseRelation.Fields fields, ReaderSupplier supplier) {
        super(fields);
        this.supplier = supplier;
    }

    public String getSourceInformation() {
        return "From TupleStorage";
    }

    protected TupleIterator rawIterator() {
        final TupleReader reader = this.supplier.get(this);
        final Struct rawType = this.getRawType();
        return new PeekingTupleIterator(){

            protected String getSource() {
                return TupleStorageRelation.this.supplier.toString();
            }

            protected Tuple get() {
                try {
                    return reader.read(rawType);
                }
                catch (IOException e) {
                    throw new RiskscapeIOException("I/O Failure reading from " + String.valueOf(reader), (Exception)e);
                }
            }
        };
    }

    protected BaseRelation clone(BaseRelation.Fields fields) {
        return new TupleStorageRelation(fields, this.supplier);
    }

    public static interface ReaderSupplier {
        public TupleReader get(TupleStorageRelation var1) throws RelationIOException;
    }
}

