/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.relation;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.gt.ConvertFilter;
import nz.org.riskscape.engine.types.Struct;
import org.geotools.api.filter.And;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.factory.CommonFactoryFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenameFilter
extends ConvertFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RenameFilter.class);
    private final Map<String, String> targetBackToSource;

    public RenameFilter(Map<Struct.StructMember, Struct.StructMember> renamings) {
        super(CommonFactoryFinder.getFilterFactory());
        this.targetBackToSource = renamings.entrySet().stream().filter(entry -> entry.getValue() != null).collect(Collectors.toMap(e -> ((Struct.StructMember)e.getValue()).getKey(), e -> ((Struct.StructMember)e.getKey()).getKey()));
    }

    protected Result convert(Filter original) {
        AtomicInteger droppedFilterParts = new AtomicInteger();
        try {
            Filter converted = (Filter)original.accept((FilterVisitor)this, (Object)droppedFilterParts);
            Outcome outcome = droppedFilterParts.get() <= 0 ? Outcome.COMPLETE : Outcome.PARTIAL;
            return new Result(converted, outcome);
        }
        catch (UnmappedExpressionException e) {
            log.debug("Could not apply renamings {} to {}", this.targetBackToSource, (Object)original);
            return new Result(null, Outcome.NONE);
        }
    }

    @Override
    public Object visit(PropertyName expression, Object extraData) {
        String mapped = this.targetBackToSource.get(expression.getPropertyName());
        if (mapped != null) {
            return this.filterFactory.property(mapped);
        }
        throw new UnmappedExpressionException(String.format("%s cannot be mapped", expression.toString()));
    }

    @Override
    public Object visit(Or filter, Object extraData) {
        ArrayList<Filter> children = new ArrayList<Filter>();
        for (Filter child : filter.getChildren()) {
            children.add((Filter)child.accept((FilterVisitor)this, extraData));
        }
        return this.filterFactory.or(children);
    }

    @Override
    public Object visit(And filter, Object extraData) {
        ArrayList<Filter> children = new ArrayList<Filter>();
        for (Filter child : filter.getChildren()) {
            try {
                children.add((Filter)child.accept((FilterVisitor)this, extraData));
            }
            catch (UnmappedExpressionException e) {
                ((AtomicInteger)extraData).incrementAndGet();
            }
        }
        if (children.isEmpty()) {
            throw new UnmappedExpressionException("Filter has no parts that can to lifted. Filter: " + filter.toString());
        }
        if (children.size() == 1) {
            return children.get(0);
        }
        return this.filterFactory.and(children);
    }

    public static enum Outcome {
        NONE,
        PARTIAL,
        COMPLETE;

    }

    public static class Result {
        private final Filter filter;
        private final Outcome outcome;

        @Generated
        public Result(Filter filter, Outcome outcome) {
            this.filter = filter;
            this.outcome = outcome;
        }

        @Generated
        public Filter getFilter() {
            return this.filter;
        }

        @Generated
        public Outcome getOutcome() {
            return this.outcome;
        }
    }

    private class UnmappedExpressionException
    extends RiskscapeException {
        UnmappedExpressionException(String message) {
            super(message);
        }
    }
}

