/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.relation;

import java.util.NoSuchElementException;
import lombok.NonNull;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.relation.BaseRelation;
import nz.org.riskscape.engine.relation.FeatureSourceRelation;
import nz.org.riskscape.engine.relation.FeatureSourceTupleIterator;
import nz.org.riskscape.engine.relation.InvalidTupleException;
import nz.org.riskscape.engine.relation.TupleIterator;
import nz.org.riskscape.engine.types.Struct;
import org.geotools.api.data.Query;
import org.geotools.api.data.ServiceInfo;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;

public class PagingFeatureSourceRelation
extends BaseRelation {
    private final SimpleFeatureSource featureSource;
    private final int pageSize;
    private final SRIDSet sridSet;
    private final Filter filter;
    private final CoordinateReferenceSystem crs;

    public PagingFeatureSourceRelation(@NonNull Struct type, @NonNull SimpleFeatureSource featureSource, @NonNull SRIDSet sridSet, @NonNull Filter filter, @NonNull CoordinateReferenceSystem crs, int pageSize) {
        super(type, null, FeatureSourceRelation.spatialMetadataFromSchema(type, (SimpleFeatureType)featureSource.getSchema(), crs));
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (featureSource == null) {
            throw new NullPointerException("featureSource is marked non-null but is null");
        }
        if (sridSet == null) {
            throw new NullPointerException("sridSet is marked non-null but is null");
        }
        if (filter == null) {
            throw new NullPointerException("filter is marked non-null but is null");
        }
        if (crs == null) {
            throw new NullPointerException("crs is marked non-null but is null");
        }
        this.filter = filter;
        this.featureSource = featureSource;
        this.sridSet = sridSet;
        this.pageSize = pageSize;
        this.crs = crs;
    }

    protected PagingFeatureSourceRelation(BaseRelation.Fields fields, @NonNull SimpleFeatureSource featureSource, @NonNull SRIDSet sridSet, @NonNull Filter filter, @NonNull CoordinateReferenceSystem crs, int pageSize) {
        super(fields);
        if (featureSource == null) {
            throw new NullPointerException("featureSource is marked non-null but is null");
        }
        if (sridSet == null) {
            throw new NullPointerException("sridSet is marked non-null but is null");
        }
        if (filter == null) {
            throw new NullPointerException("filter is marked non-null but is null");
        }
        if (crs == null) {
            throw new NullPointerException("crs is marked non-null but is null");
        }
        this.filter = filter;
        this.featureSource = featureSource;
        this.sridSet = sridSet;
        this.crs = crs;
        this.pageSize = pageSize;
    }

    public TupleIterator rawIterator() {
        return new TupleIterator(){
            private Tuple tuple;
            private int tuplePeekCount = 0;
            private boolean exhausted = false;
            private TupleIterator currentIterator;

            private Tuple peek() {
                while (this.tuple == null && !this.exhausted) {
                    if (this.currentIterator == null || !this.currentIterator.hasNext()) {
                        this.currentIterator = this.nextIterator();
                    }
                    if (!this.currentIterator.hasNext()) {
                        this.exhausted = true;
                        continue;
                    }
                    try {
                        this.tuple = (Tuple)this.currentIterator.next();
                    }
                    catch (InvalidTupleException e) {
                        PagingFeatureSourceRelation.this.skipOrThrow(e);
                    }
                    ++this.tuplePeekCount;
                }
                return this.tuple;
            }

            private TupleIterator nextIterator() {
                int startIndex = this.tuplePeekCount;
                int maxFeatures = startIndex + PagingFeatureSourceRelation.this.pageSize;
                if (this.tuplePeekCount % PagingFeatureSourceRelation.this.pageSize != 0) {
                    return this.currentIterator;
                }
                Query query = new Query();
                query.setStartIndex(Integer.valueOf(startIndex));
                query.setMaxFeatures(maxFeatures);
                query.setFilter(PagingFeatureSourceRelation.this.filter);
                return FeatureSourceTupleIterator.fromQuery(PagingFeatureSourceRelation.this.featureSource, query, PagingFeatureSourceRelation.this.sridSet, PagingFeatureSourceRelation.this.getRawType(), PagingFeatureSourceRelation.this.crs);
            }

            public Tuple next() {
                Tuple peeked = this.peek();
                if (peeked == null) {
                    throw new NoSuchElementException();
                }
                this.tuple = null;
                return peeked;
            }

            public boolean hasNext() {
                return this.peek() != null;
            }
        };
    }

    public String getSourceInformation() {
        ServiceInfo info = this.featureSource.getDataStore().getInfo();
        return info.getSource() == null ? info.getTitle() : info.getSource().toString();
    }

    protected BaseRelation clone(BaseRelation.Fields fields) {
        return new PagingFeatureSourceRelation(fields, this.featureSource, this.sridSet, this.filter, this.crs, this.pageSize);
    }
}

