/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.relation;

import java.io.IOException;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import nz.org.riskscape.engine.RiskscapeIOException;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.data.InputDataProblems;
import nz.org.riskscape.engine.data.relation.FeatureSourceBookmarkResolver;
import nz.org.riskscape.engine.relation.FeatureSourceRelation;
import nz.org.riskscape.engine.relation.InvalidTupleException;
import nz.org.riskscape.engine.relation.TupleIterator;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.problem.Problem;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureIterator;

public class FeatureSourceTupleIterator
implements TupleIterator {
    public final FeatureIterator<SimpleFeature> internal;
    public final Struct type;
    private boolean finished = false;

    public static FeatureSourceTupleIterator fromQuery(@NonNull SimpleFeatureSource featureSource, @NonNull Query query, @NonNull SRIDSet sridSet, @NonNull Struct type, @NonNull CoordinateReferenceSystem crs) {
        SimpleFeatureIterator features;
        if (featureSource == null) {
            throw new NullPointerException("featureSource is marked non-null but is null");
        }
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (sridSet == null) {
            throw new NullPointerException("sridSet is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (crs == null) {
            throw new NullPointerException("crs is marked non-null but is null");
        }
        try {
            Query hintedQuery = sridSet.queryWithHints(Query.ALL, crs);
            query.setHints(hintedQuery.getHints());
            features = featureSource.getFeatures(query).features();
        }
        catch (IOException e) {
            throw new RiskscapeIOException(String.format("Error while requesting features from feature source %s", featureSource), (Exception)e);
        }
        return new FeatureSourceTupleIterator((FeatureIterator<SimpleFeature>)features, type);
    }

    public FeatureSourceTupleIterator(FeatureIterator<SimpleFeature> iterator, Struct type) {
        this.internal = iterator;
        this.type = type;
    }

    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        this.finished = !this.internal.hasNext();
        return !this.finished;
    }

    public Tuple next() {
        SimpleFeature sf = (SimpleFeature)this.internal.next();
        Tuple tuple = new Tuple(this.type);
        Problem tupleProblem = null;
        List members = this.getType().getMembers();
        for (Struct.StructMember member : members) {
            if (member.getType() == FeatureSourceRelation.FID_TYPE) {
                tuple.set(member, (Object)sf.getID());
                continue;
            }
            Object value = sf.getAttribute(member.getKey());
            if (value != null) {
                tuple.set(member, member.getType().coerce(value));
                continue;
            }
            Struct.StructMember geomMember = FeatureSourceRelation.geometryStructMember(this.type, sf.getFeatureType());
            if (!member.equals((Object)geomMember)) continue;
            tupleProblem = InputDataProblems.get().nullGeometry(geomMember.getKey(), sf.getID());
        }
        if (tupleProblem != null) {
            throw new InvalidTupleException(tuple, tupleProblem);
        }
        return tuple;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public void close() {
        FeatureSourceBookmarkResolver.LOCK_DEFEATER.call("close", () -> {
            this.internal.close();
            return null;
        });
    }

    @Generated
    public Struct getType() {
        return this.type;
    }
}

