/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.relation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.data.relation.FeatureSourceBookmarkResolver;
import nz.org.riskscape.engine.relation.BaseRelation;
import nz.org.riskscape.engine.relation.FeatureSourceTupleIterator;
import nz.org.riskscape.engine.relation.RenameFilter;
import nz.org.riskscape.engine.relation.SpatialMetadata;
import nz.org.riskscape.engine.restriction.ExpressionRestriction;
import nz.org.riskscape.engine.restriction.Restriction;
import nz.org.riskscape.engine.types.Geom;
import nz.org.riskscape.engine.types.Referenced;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Text;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Geometry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureSourceRelation
extends BaseRelation {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FeatureSourceRelation.class);
    public static final String FID_MEMBER_NAME = "_fid";
    public static final Type FID_TYPE = new Text();
    @NonNull
    private final SRIDSet sridSet;
    @NonNull
    private final SimpleFeatureSource featureSource;
    @NonNull
    private final Filter filter;
    protected final CoordinateReferenceSystem crs;
    private Optional<Long> size = null;

    public static Struct fromFeatureSource(SimpleFeatureSource fs, boolean includeFid) {
        SimpleFeatureType type = (SimpleFeatureType)fs.getSchema();
        ReferencedEnvelope bounds = null;
        try {
            bounds = fs.getBounds();
            if (bounds == null) {
                log.warn("Feature source returned a null bounds. This is because it would be too costly to calculate the actual bounds");
            }
        }
        catch (IOException e) {
            log.warn("Bounds could not be calculated", (Throwable)e);
        }
        return FeatureSourceRelation.fromFeatureType(type, bounds, includeFid);
    }

    public static Struct fromFeatureType(SimpleFeatureType type, ReferencedEnvelope bounds, boolean includeFid) {
        Struct.StructBuilder structBuilder = Struct.builder();
        if (includeFid) {
            structBuilder.add(FID_MEMBER_NAME, FID_TYPE);
        }
        GeometryDescriptor geomDescriptor = type.getGeometryDescriptor();
        for (AttributeDescriptor attributeDescriptor : type.getAttributeDescriptors()) {
            String key = attributeDescriptor.getLocalName();
            Class binding = attributeDescriptor.getType().getBinding();
            if (binding == FeatureTypeStyle.class) continue;
            Type riskscapeType = Types.fromJavaType((Class)binding);
            if (attributeDescriptor.equals(geomDescriptor)) {
                Type geometryType = Geom.fromJavaType(attributeDescriptor.getType().getBinding().asSubclass(Geometry.class));
                if (bounds != null && bounds.getCoordinateReferenceSystem() != null) {
                    riskscapeType = Referenced.ofNullable((Type)geometryType, (ReferencedEnvelope)bounds);
                }
            }
            structBuilder.add(key, riskscapeType);
        }
        return structBuilder.build();
    }

    public static Struct.StructMember geometryStructMember(Struct struct, SimpleFeatureType schema) {
        GeometryDescriptor descriptor = schema.getGeometryDescriptor();
        return descriptor == null ? null : struct.getEntry(descriptor.getLocalName());
    }

    public static SpatialMetadata spatialMetadataFromSchema(Struct struct, SimpleFeatureType schema, CoordinateReferenceSystem crs) {
        Struct.StructMember geometryMember = FeatureSourceRelation.geometryStructMember(struct, schema);
        if (geometryMember != null) {
            return new SpatialMetadata(crs, geometryMember);
        }
        return null;
    }

    public FeatureSourceRelation(SimpleFeatureSource fs, SRIDSet sridSet, CoordinateReferenceSystem crs) {
        this(FeatureSourceRelation.fromFeatureSource(fs, false), fs, sridSet, (Filter)Filter.INCLUDE, crs);
    }

    public FeatureSourceRelation(@NonNull Struct type, @NonNull SimpleFeatureSource fs, @NonNull SRIDSet sridSet, CoordinateReferenceSystem crs) {
        this(type, fs, sridSet, (Filter)Filter.INCLUDE, crs);
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (fs == null) {
            throw new NullPointerException("fs is marked non-null but is null");
        }
        if (sridSet == null) {
            throw new NullPointerException("sridSet is marked non-null but is null");
        }
    }

    public FeatureSourceRelation(@NonNull Struct type, @NonNull SimpleFeatureSource fs, @NonNull SRIDSet sridSet, @NonNull Filter filter, @NonNull CoordinateReferenceSystem crs) {
        super(type, null, FeatureSourceRelation.spatialMetadataFromSchema(type, (SimpleFeatureType)fs.getSchema(), crs));
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (fs == null) {
            throw new NullPointerException("fs is marked non-null but is null");
        }
        if (sridSet == null) {
            throw new NullPointerException("sridSet is marked non-null but is null");
        }
        if (filter == null) {
            throw new NullPointerException("filter is marked non-null but is null");
        }
        if (crs == null) {
            throw new NullPointerException("crs is marked non-null but is null");
        }
        this.sridSet = sridSet;
        this.featureSource = fs;
        this.filter = filter;
        this.crs = crs;
        this.getSpatialMetadata().ifPresent(sm -> sridSet.get(sm.getCrs()));
    }

    protected FeatureSourceRelation(@NonNull BaseRelation.Fields clonedFields, @NonNull SimpleFeatureSource fs, @NonNull SRIDSet sridSet, @NonNull Filter filter, @NonNull CoordinateReferenceSystem crs) {
        super(clonedFields);
        if (clonedFields == null) {
            throw new NullPointerException("clonedFields is marked non-null but is null");
        }
        if (fs == null) {
            throw new NullPointerException("fs is marked non-null but is null");
        }
        if (sridSet == null) {
            throw new NullPointerException("sridSet is marked non-null but is null");
        }
        if (filter == null) {
            throw new NullPointerException("filter is marked non-null but is null");
        }
        if (crs == null) {
            throw new NullPointerException("crs is marked non-null but is null");
        }
        this.sridSet = sridSet;
        this.featureSource = fs;
        this.filter = filter;
        this.crs = crs;
        this.getSpatialMetadata().ifPresent(sm -> sridSet.get(sm.getCrs()));
    }

    public FeatureSourceTupleIterator rawIterator() {
        Query query = new Query();
        query.setFilter(this.filter);
        return FeatureSourceBookmarkResolver.LOCK_DEFEATER.call("build-fs-from-query", () -> FeatureSourceTupleIterator.fromQuery(this.featureSource, query, this.sridSet, this.getRawType(), this.crs));
    }

    public String getSourceInformation() {
        return this.featureSource.getDataStore() == null ? "unknown" : this.featureSource.getDataStore().toString();
    }

    /*
     * WARNING - void declaration
     */
    protected BaseRelation cloneWithRestrictionIfSupported(Restriction restriction) {
        void var9_18;
        Filter newFilter;
        if (!(restriction instanceof ExpressionRestriction)) {
            return null;
        }
        ExpressionRestriction exprRestriction = (ExpressionRestriction)restriction;
        try {
            newFilter = ECQL.toFilter((String)exprRestriction.getExpression().toSource());
        }
        catch (CQLException e) {
            return null;
        }
        ArrayList transformations = new ArrayList(this.transformers.length);
        for (BaseRelation.Transformer transformer : this.transformers) {
            if (transformer.projectionFunction == null) continue;
            Map map = transformer.projectionFunction.getDirectMapping();
            HashMap<Struct.StructMember, Struct.StructMember> sourceToTarget = new HashMap<Struct.StructMember, Struct.StructMember>();
            for (Map.Entry entry : map.entrySet()) {
                if (((List)entry.getValue()).size() != 1 || ((List)entry.getKey()).size() != 1) continue;
                sourceToTarget.put((Struct.StructMember)((List)entry.getValue()).get(0), (Struct.StructMember)((List)entry.getKey()).get(0));
            }
            transformations.add(sourceToTarget);
        }
        Map<Struct.StructMember, Struct.StructMember> mappedAttributes = this.getRawType().getMembers().stream().collect(Collectors.toMap(Function.identity(), Function.identity()));
        block4: for (Map.Entry mapped : mappedAttributes.entrySet()) {
            for (Map map : transformations) {
                Struct.StructMember targetMember = (Struct.StructMember)map.get(mapped.getValue());
                if (targetMember != null) {
                    mapped.setValue(targetMember);
                    continue;
                }
                mapped.setValue(null);
                continue block4;
            }
        }
        RenameFilter converter = new RenameFilter(mappedAttributes);
        RenameFilter.Result renamed = converter.convert(newFilter);
        if (renamed.getOutcome() == RenameFilter.Outcome.NONE) {
            return null;
        }
        log.debug("Filter {} converted to {} for push up in to feature source {}", new Object[]{newFilter, renamed.getFilter(), this.getSourceInformation()});
        Filter combinedFilter = newFilter == Filter.INCLUDE ? renamed.getFilter() : CommonFactoryFinder.getFilterFactory().and(renamed.getFilter(), this.filter);
        FeatureSourceRelation featureSourceRelation = new FeatureSourceRelation(new BaseRelation.Fields((BaseRelation)this), this.featureSource, this.sridSet, combinedFilter, this.crs);
        if (renamed.getOutcome() == RenameFilter.Outcome.PARTIAL) {
            BaseRelation baseRelation = featureSourceRelation.cloneWithTransformer(new BaseRelation.Transformer((BaseRelation)this, this.getType(), restriction));
        }
        return var9_18;
    }

    protected BaseRelation clone(BaseRelation.Fields fields) {
        return new FeatureSourceRelation(fields, this.featureSource, this.sridSet, this.filter, this.crs);
    }

    public Optional<Long> size() {
        if (this.size == null) {
            try {
                Query query = new Query();
                query.setFilter(this.filter);
                long featureCount = this.featureSource.getCount(query);
                this.size = featureCount >= 0L ? Optional.of(featureCount) : Optional.empty();
            }
            catch (IOException e) {
                this.size = Optional.empty();
            }
        }
        return this.size;
    }

    @NonNull
    @Generated
    public SRIDSet getSridSet() {
        return this.sridSet;
    }

    @NonNull
    @Generated
    public SimpleFeatureSource getFeatureSource() {
        return this.featureSource;
    }

    @NonNull
    @Generated
    public Filter getFilter() {
        return this.filter;
    }
}

