/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.raster;

import com.google.common.collect.ImmutableMap;
import it.geosolutions.jaiext.range.NoDataContainer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;
import javax.media.jai.TiledImage;
import lombok.Generated;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.grid.FeatureGrid;
import nz.org.riskscape.engine.grid.FeatureGridCell;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.relation.Relation;
import nz.org.riskscape.engine.relation.SpatialMetadata;
import nz.org.riskscape.engine.relation.TupleIterator;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.geometry.jts.Geometries;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.metadata.i18n.Vocabulary;
import org.geotools.referencing.CRS;
import org.geotools.util.NumberRange;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorToRaster {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VectorToRaster.class);
    public static final LocalProblems PROBLEMS = (LocalProblems)Problems.get(LocalProblems.class);
    private float minAttValue = Float.NaN;
    private float maxAttValue = Float.NaN;
    private ReferencedEnvelope extent;
    private CRS.AxisOrder axisOrder;
    private Geometry extentGeometry;
    private GridGeometry2D gridGeom;
    private PixelStrategy pixelStrategy;
    TiledImage image;
    private final Color noDataColor = new Color(Float.floatToIntBits(Float.NaN), true);

    public static double getHeightCrsUnits(ReferencedEnvelope bounds) {
        CRS.AxisOrder axisOrder = CRS.getAxisOrder((CoordinateReferenceSystem)bounds.getCoordinateReferenceSystem());
        return axisOrder == CRS.AxisOrder.EAST_NORTH ? bounds.getHeight() : bounds.getWidth();
    }

    public static double getWidthCrsUnits(ReferencedEnvelope bounds) {
        CRS.AxisOrder axisOrder = CRS.getAxisOrder((CoordinateReferenceSystem)bounds.getCoordinateReferenceSystem());
        return axisOrder == CRS.AxisOrder.EAST_NORTH ? bounds.getWidth() : bounds.getHeight();
    }

    public static ResultOrProblems<Dimension> getDimensions(ReferencedEnvelope bounds, double scale) {
        Dimension gridDim = new Dimension((int)Math.ceil(scale * VectorToRaster.getWidthCrsUnits(bounds)), (int)Math.ceil(scale * VectorToRaster.getHeightCrsUnits(bounds)));
        if (1L * (long)gridDim.width * (long)gridDim.height > Integer.MAX_VALUE) {
            return ResultOrProblems.failed((Problem[])new Problem[]{PROBLEMS.gridDimensionsTooBig(gridDim.width, gridDim.height, Integer.MAX_VALUE)});
        }
        return ResultOrProblems.of((Object)gridDim);
    }

    private static PixelSetter pixelSetter(BiFunction<Float, Float, Float> mergeFunc) {
        return VectorToRaster.pixelSetter(0, mergeFunc);
    }

    private static PixelSetter pixelSetter(int band, BiFunction<Float, Float, Float> mergeFunc) {
        return (theImage, grid, value) -> {
            float existing = theImage.getSampleFloat(grid.x, grid.y, band);
            if (!Float.isNaN(existing)) {
                value = ((Float)mergeFunc.apply(Float.valueOf(value), Float.valueOf(existing))).floatValue();
            }
            theImage.setSample(grid.x, grid.y, band, value);
        };
    }

    private static PixelSetter compositeSetter(PixelSetter ... children) {
        return (theImage, grid, value) -> {
            for (PixelSetter child : children) {
                child.setPixel(theImage, grid, value);
            }
        };
    }

    public GridCoverage2D convert(Relation relation, RealizedExpression expression, double scale, ReferencedEnvelope bounds, String covName) throws ProblemException {
        this.initialize(bounds, scale, PixelStrategy.OVERWRITE);
        this.drawAll(relation, expression);
        return this.constructCoverage(covName);
    }

    private DrawFeatureResult drawFeature(Tuple feature, RealizedExpression valueExpression, Struct.StructMember geomMember) {
        Geometry geometry = (Geometry)feature.fetch(geomMember);
        return this.drawFeature((Number)valueExpression.evaluate((Object)feature), geometry);
    }

    public DrawFeatureResult drawFeature(Number value, Geometry geometry) {
        if (value == null || geometry == null || Float.isNaN(value.floatValue())) {
            return DrawFeatureResult.SKIPPED_NO_VALUE_OR_GEOMETRY;
        }
        if (geometry.intersects(this.extentGeometry)) {
            float featureValue = value.floatValue();
            if (Float.isNaN(this.minAttValue)) {
                this.minAttValue = featureValue;
                this.maxAttValue = featureValue;
            } else if (Float.compare(featureValue, this.minAttValue) < 0) {
                this.minAttValue = featureValue;
            } else if (Float.compare(featureValue, this.maxAttValue) > 0) {
                this.maxAttValue = featureValue;
            }
            Geometries geomType = Geometries.get((Geometry)geometry);
            switch (geomType) {
                case MULTIPOLYGON: 
                case MULTILINESTRING: 
                case MULTIPOINT: {
                    int numGeom = geometry.getNumGeometries();
                    for (int i = 0; i < numGeom; ++i) {
                        Geometry geomN = geometry.getGeometryN(i);
                        this.drawGeometry(geomN, featureValue);
                    }
                    break;
                }
                case POLYGON: 
                case LINESTRING: 
                case POINT: {
                    this.drawGeometry(geometry, featureValue);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported geometry type: " + geomType.getName());
                }
            }
            return DrawFeatureResult.DRAWN;
        }
        return DrawFeatureResult.OUT_OF_BOUNDS;
    }

    public GridCoverage2D constructCoverage(CharSequence covName) {
        try {
            GridCoverageFactory gcf = new GridCoverageFactory();
            float noDataValue = Float.intBitsToFloat(this.noDataColor.getRGB());
            ImmutableMap properties = ImmutableMap.of((Object)"GC_NODATA", (Object)new NoDataContainer((double)noDataValue));
            Category category = new Category((CharSequence)Vocabulary.formatInternational((int)147), new Color[]{new Color(0, 0, 0, 0)}, NumberRange.create((float)noDataValue, (float)noDataValue));
            GridSampleDimension[] bands = new GridSampleDimension[]{new GridSampleDimension((CharSequence)"Rasterized", new Category[]{category}, null)};
            TiledImage imageToWrite = this.postProcessImageIfNecessary();
            return gcf.create(covName, (RenderedImage)imageToWrite, this.gridGeom, bands, null, (Map)properties);
        }
        catch (Throwable t) {
            throw new RiskscapeException((Problems)PROBLEMS.couldNotConstructCoverage(Problems.caught((Throwable)t)));
        }
    }

    private TiledImage postProcessImageIfNecessary() {
        if (this.pixelStrategy.postProcessor == null) {
            return this.image;
        }
        for (int yt = 0; yt < this.image.getNumYTiles(); ++yt) {
            for (int xt = 0; xt < this.image.getNumXTiles(); ++xt) {
                WritableRaster r = this.image.getWritableTile(xt, yt);
                for (int x = r.getMinX(); x < r.getMinX() + r.getWidth(); ++x) {
                    for (int y = r.getMinY(); y < r.getMinY() + r.getHeight(); ++y) {
                        float f0 = this.image.getSampleFloat(x, y, 0);
                        if (Float.isNaN(f0)) continue;
                        ArrayList<Float> samples = new ArrayList<Float>(this.pixelStrategy.bandDefaults.length);
                        samples.add(Float.valueOf(f0));
                        for (int i = 1; i < this.pixelStrategy.bandDefaults.length; ++i) {
                            samples.add(Float.valueOf(this.image.getSampleFloat(x, y, i)));
                        }
                        this.image.setSample(x, y, 0, this.pixelStrategy.postProcessor.apply(samples).floatValue());
                    }
                }
                this.image.releaseWritableTile(xt, yt);
            }
        }
        return this.image.getSubImage(new int[]{0}, (ColorModel)new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 4));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void drawAll(Relation relation, RealizedExpression expression) {
        Struct.StructMember geometryStructMember = ((SpatialMetadata)relation.getSpatialMetadata().get()).getGeometryStructMember();
        try (TupleIterator fi = relation.iterator();){
            log.info("Rasterizing {}...", (Object)relation);
            while (fi.hasNext()) {
                try {
                    this.drawFeature((Tuple)fi.next(), expression, geometryStructMember);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                    return;
                }
            }
        }
    }

    public void initialize(ReferencedEnvelope bounds, double scale, PixelStrategy newPixelStrategy) throws ProblemException {
        this.pixelStrategy = newPixelStrategy;
        Dimension gridDim = (Dimension)VectorToRaster.getDimensions(bounds, scale).getOrThrow();
        this.setBounds(bounds);
        this.axisOrder = CRS.getAxisOrder((CoordinateReferenceSystem)bounds.getCoordinateReferenceSystem());
        this.image = this.createImage(gridDim, newPixelStrategy.bandDefaults.length);
        log.debug("Allocated image for rasterization {}", (Object)this.image);
        for (int yt = 0; yt < this.image.getNumYTiles(); ++yt) {
            for (int xt = 0; xt < this.image.getNumXTiles(); ++xt) {
                WritableRaster r = this.image.getWritableTile(xt, yt);
                for (int x = r.getMinX(); x < r.getMinX() + r.getWidth(); ++x) {
                    for (int y = r.getMinY(); y < r.getMinY() + r.getHeight(); ++y) {
                        for (int band = 0; band < newPixelStrategy.bandDefaults.length; ++band) {
                            r.setSample(x, y, band, newPixelStrategy.bandDefaults[band]);
                        }
                    }
                }
                this.image.releaseWritableTile(xt, yt);
            }
        }
        this.gridGeom = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(0, 0, gridDim.width, gridDim.height), (Bounds)this.extent);
    }

    private void setBounds(ReferencedEnvelope bounds) {
        this.extent = bounds;
        this.extentGeometry = new GeometryFactory().toGeometry((Envelope)this.extent);
    }

    private TiledImage createImage(Dimension gridDim, int bands) {
        SampleModel sm = RasterFactory.createPixelInterleavedSampleModel((int)4, (int)gridDim.width, (int)gridDim.height, (int)bands);
        return new TiledImage(0, 0, gridDim.width, gridDim.height, 0, 0, sm, PlanarImage.createColorModel((SampleModel)sm));
    }

    private void drawGeometry(Geometry geometry, float featureValue) {
        FeatureGrid featureGrid;
        if (Float.isNaN(featureValue)) {
            return;
        }
        try {
            featureGrid = new FeatureGrid(geometry, this.axisOrder, this.gridGeom);
        }
        catch (TransformException e) {
            throw new RiskscapeException((Problems)Problems.caught((Throwable)e));
        }
        Iterator<FeatureGridCell> cells = featureGrid.cellIterator();
        while (cells.hasNext()) {
            FeatureGridCell cell = cells.next();
            if (!geometry.intersects((Geometry)cell.getCellPolygon())) continue;
            GridCoordinates2D gridPosition = cell.getGridPosition();
            this.pixelStrategy.pixelSetter.setPixel(this.image, gridPosition, featureValue);
        }
    }

    public static interface LocalProblems
    extends ProblemFactory {
        public Problem couldNotConstructCoverage(Problem ... var1);

        public Problem gridDimensionsTooBig(long var1, long var3, int var5);
    }

    @FunctionalInterface
    private static interface PixelSetter {
        public void setPixel(TiledImage var1, GridCoordinates2D var2, float var3);
    }

    public static enum PixelStrategy {
        OVERWRITE((theImage, grid, value) -> theImage.setSample(grid.x, grid.y, 0, value)),
        MIN(VectorToRaster.pixelSetter((newValue, existing) -> Float.valueOf(Math.min(newValue.floatValue(), existing.floatValue())))),
        MAX(VectorToRaster.pixelSetter((newValue, existing) -> Float.valueOf(Math.max(newValue.floatValue(), existing.floatValue())))),
        SUM(VectorToRaster.pixelSetter((newValue, existing) -> Float.valueOf(newValue.floatValue() + existing.floatValue()))),
        MEAN(new float[]{Float.NaN, 0.0f}, VectorToRaster.compositeSetter(VectorToRaster.pixelSetter(0, (newValue, existing) -> Float.valueOf(newValue.floatValue() + existing.floatValue())), VectorToRaster.pixelSetter(1, (newValue, existing) -> Float.valueOf(1.0f + existing.floatValue()))), samples -> Float.valueOf(((Float)samples.get(0)).floatValue() / ((Float)samples.get(1)).floatValue()));

        final PixelSetter pixelSetter;
        final float[] bandDefaults;
        final Function<List<Float>, Float> postProcessor;

        private PixelStrategy(PixelSetter pixelSetter) {
            this.pixelSetter = pixelSetter;
            this.bandDefaults = new float[]{Float.NaN};
            this.postProcessor = null;
        }

        private PixelStrategy(float[] bandDefaults, PixelSetter pixelSetter, Function<List<Float>, Float> postProcessor) {
            this.pixelSetter = pixelSetter;
            this.postProcessor = postProcessor;
            this.bandDefaults = bandDefaults;
        }
    }

    public static enum DrawFeatureResult {
        SKIPPED_NO_VALUE_OR_GEOMETRY,
        OUT_OF_BOUNDS,
        DRAWN;

    }
}

