/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.projection;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import nz.org.riskscape.engine.GeometryProblems;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.geo.GeometryFixer;
import nz.org.riskscape.engine.geo.GeometryValidation;
import nz.org.riskscape.engine.projection.Projection;
import nz.org.riskscape.engine.projection.Projector;
import nz.org.riskscape.engine.query.TupleUtils;
import nz.org.riskscape.engine.relation.InvalidTupleException;
import nz.org.riskscape.engine.relation.SpatialMetadata;
import nz.org.riskscape.engine.types.Geom;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemSink;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.operation.valid.IsValidOp;

public class ValidateGeometryProjection
implements Projection {
    private final GeometryValidation mode;
    private final Object context;
    private final ProblemSink problemSink;

    public ResultOrProblems<Struct> projectType(Struct source) {
        return ResultOrProblems.of((Object)source);
    }

    public ResultOrProblems<Projector> getProjectionFunction(Struct sourceType) {
        ArrayList<Struct.StructMember> geometryMembers = new ArrayList<Struct.StructMember>();
        for (Struct.StructMember member : sourceType.getMembers()) {
            if (!member.getType().findAllowNull(Geom.class).isPresent()) continue;
            geometryMembers.add(member);
        }
        return ResultOrProblems.of((Object)new ValidateGeometryProjector(geometryMembers, sourceType));
    }

    @Generated
    public ValidateGeometryProjection(GeometryValidation mode, Object context, ProblemSink problemSink) {
        this.mode = mode;
        this.context = context;
        this.problemSink = problemSink;
    }

    protected class ValidateGeometryProjector
    implements Projector {
        private final List<Struct.StructMember> geometryMembers;
        private final Struct struct;
        private final GeometryFixer geometryFixer = GeometryFixer.DEFAULT;

        public Tuple apply(Tuple t) {
            if (ValidateGeometryProjection.this.mode != GeometryValidation.OFF) {
                for (Struct.StructMember geometryMember : this.geometryMembers) {
                    IsValidOp isValidOp;
                    Geometry geom = (Geometry)t.fetch(geometryMember);
                    if (geom == null || (isValidOp = new IsValidOp(geom)).isValid()) continue;
                    Geometry fixed = this.geometryFixer.fix(geom);
                    if (fixed != null) {
                        ValidateGeometryProjection.this.problemSink.log(Problems.foundWith((Object)ValidateGeometryProjection.this.context, (Problems)GeometryProblems.get().fixedInvalid(geom, fixed, TupleUtils.getContentSummary((Tuple)t))));
                        t.set(geometryMember, (Object)fixed);
                        continue;
                    }
                    Problem invalidProblem = GeometryProblems.get().invalid(geom, isValidOp.getValidationError(), TupleUtils.getContentSummary((Tuple)t));
                    if (ValidateGeometryProjection.this.mode == GeometryValidation.ERROR) {
                        throw new InvalidTupleException(t, invalidProblem);
                    }
                    ValidateGeometryProjection.this.problemSink.log(Problems.foundWith((Object)ValidateGeometryProjection.this.context, (Problems)invalidProblem.withSeverity(Problem.Severity.WARNING)));
                }
            }
            return t;
        }

        public Struct getProducedType() {
            return this.struct;
        }

        public Struct getSourceType() {
            return this.struct;
        }

        public Map<List<Struct.StructMember>, List<Struct.StructMember>> getDirectMapping() {
            return Projector.identityMapping((Struct)this.struct);
        }

        public Optional<Function<SpatialMetadata, SpatialMetadata>> getSpatialMetadataMapper() {
            return Optional.empty();
        }

        @Generated
        public ValidateGeometryProjector(List<Struct.StructMember> geometryMembers, Struct struct) {
            this.geometryMembers = geometryMembers;
            this.struct = struct;
        }
    }
}

