/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.projection;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.projection.Projector;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.typeset.TypeSet;
import nz.org.riskscape.problem.ResultOrProblems;

public class UnionProjector
implements Projector {
    private final List<Struct> sourceTypes;
    private final Struct producedType;

    public static Struct unionOf(TypeSet typeSet, Struct a, Struct b) {
        Struct combined = Struct.EMPTY_STRUCT;
        for (Struct.StructMember member : a.getMembers()) {
            combined = combined.add(member.getKey(), UnionProjector.combinedType(typeSet, member, b));
        }
        for (Struct.StructMember member : b.getMembers()) {
            if (combined.hasMember(member.getKey())) continue;
            combined = combined.add(member.getKey(), UnionProjector.combinedType(typeSet, member, a));
        }
        return combined;
    }

    public static ResultOrProblems<? extends Projector> realize(TypeSet typeSet, List<Struct> inputTypes) {
        Struct projectedStruct = inputTypes.get(0);
        for (int i = 1; i < inputTypes.size(); ++i) {
            Struct struct = inputTypes.get(i);
            projectedStruct = UnionProjector.unionOf(typeSet, projectedStruct, struct);
        }
        return ResultOrProblems.of((Object)new UnionProjector(inputTypes, projectedStruct));
    }

    public static ResultOrProblems<? extends Projector> realize(TypeSet typeSet, Struct ... inputTypes) {
        return UnionProjector.realize(typeSet, Arrays.asList(inputTypes));
    }

    private static Type combinedType(TypeSet typeSet, Struct.StructMember member, Struct mergeWith) {
        if (!mergeWith.hasMember(member.getKey())) {
            return Nullable.of((Type)member.getType());
        }
        Type thisType = member.getType();
        Optional thisStruct = thisType.findAllowNull(Struct.class);
        Type otherType = mergeWith.getEntry(member.getKey()).getType();
        Optional otherStruct = otherType.findAllowNull(Struct.class);
        if (thisStruct.isPresent() && otherStruct.isPresent()) {
            return Nullable.ifTrue((boolean)Nullable.any((Type[])new Type[]{thisType, otherType}), (Type)UnionProjector.unionOf(typeSet, (Struct)thisStruct.get(), (Struct)otherStruct.get()));
        }
        return typeSet.computeAncestorNoConversion(thisType, otherType);
    }

    private Object fetchOrNull(Tuple t, String attribute) {
        if (t.getStruct().hasMember(attribute)) {
            return t.fetch(attribute);
        }
        return null;
    }

    private Tuple adaptToType(Tuple input, Struct expectedType) {
        Tuple adapted = new Tuple(expectedType);
        for (Struct.StructMember member : expectedType.getMembers()) {
            Object value = this.fetchOrNull(input, member.getKey());
            if (value != null && member.getType().isA(Struct.class)) {
                value = this.adaptToType((Tuple)value, (Struct)member.getType());
            }
            adapted.set(member, value);
        }
        return adapted;
    }

    public Tuple apply(Tuple t) {
        return this.adaptToType(t, this.producedType);
    }

    public Struct getSourceType() {
        return this.sourceTypes.get(0);
    }

    @Generated
    public UnionProjector(List<Struct> sourceTypes, Struct producedType) {
        this.sourceTypes = sourceTypes;
        this.producedType = producedType;
    }

    @Generated
    public List<Struct> getSourceTypes() {
        return this.sourceTypes;
    }

    @Generated
    public Struct getProducedType() {
        return this.producedType;
    }
}

