/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.projection;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.expr.StructMemberAccessExpression;
import nz.org.riskscape.engine.projection.Projection;
import nz.org.riskscape.engine.projection.Projector;
import nz.org.riskscape.engine.relation.InvalidTupleException;
import nz.org.riskscape.engine.relation.TypeCheckingOptions;
import nz.org.riskscape.engine.rl.EvalException;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.types.CoercionException;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.SimpleType;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.typeset.TypeSet;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemCode;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.PropertyAccess;

public class TypeProjection
implements Projection {
    private final Struct targetType;
    private final Map<String, Expression> mapAttributes;
    private final EnumSet<TypeCheckingOptions> options;
    private final RealizationContext realizationContext;

    public TypeProjection(Struct targetType, RealizationContext realizationContext) {
        this(targetType, (Map<String, Expression>)ImmutableMap.of(), EnumSet.of(TypeCheckingOptions.COERCE), realizationContext);
    }

    public TypeProjection(Struct targetType, Map<String, Expression> attributeMap, RealizationContext realizationContext) {
        this(targetType, attributeMap, EnumSet.of(TypeCheckingOptions.COERCE), realizationContext);
    }

    public ResultOrProblems<Struct> projectType(Struct source) {
        return ResultOrProblems.of((Object)this.targetType);
    }

    public ResultOrProblems<Projector> getProjectionFunction(Struct sourceType) {
        return this.buildMemberList(sourceType).map(mapping -> new TypeProjector(sourceType, mapping.targetType, mapping.memberList));
    }

    protected ResultOrProblems<Mapping> buildMemberList(Struct sourceType) {
        Struct provisionalTargetType = this.targetType;
        TypeSet typeSet = this.realizationContext.getProject().getTypeSet();
        LinkedHashMap<String, RealizedExpression> memberMap = new LinkedHashMap<String, RealizedExpression>(this.targetType.getMembers().size());
        ArrayList<Problem> problems = new ArrayList<Problem>();
        for (Struct.StructMember targetMember : this.targetType.getMembers()) {
            ResultOrProblems realizedSourceExpr;
            String targetKey = targetMember.getKey();
            Expression sourceExpr = this.mapAttributes.get(targetKey);
            if (sourceExpr == null) {
                if (sourceType.hasMember(targetMember.getKey())) {
                    sourceExpr = PropertyAccess.of((String[])new String[]{targetMember.getKey()});
                } else {
                    if (targetMember.getType().isNullable()) continue;
                    problems.add(Problem.error((ProblemCode)ProblemCodes.MISSING_MEMBER, (Object[])new Object[]{targetKey}));
                    continue;
                }
            }
            if ((realizedSourceExpr = this.realizationContext.getExpressionRealizer().realize((Type)sourceType, sourceExpr)).hasProblems(Problem.Severity.ERROR)) {
                problems.add(Problem.error((ProblemCode)ProblemCodes.BAD_MAPPING, (Object[])new Object[]{targetKey, sourceExpr.toSource()}).withChildren(realizedSourceExpr.getProblems()));
                continue;
            }
            memberMap.put(targetMember.getKey(), (RealizedExpression)realizedSourceExpr.get());
            boolean nullableTarget = Nullable.is((Type)targetMember.getType());
            Type targetMemberType = Nullable.strip((Type)targetMember.getType());
            Type sourceMemberType = ((RealizedExpression)realizedSourceExpr.get()).getResultType();
            if (sourceMemberType.equals(targetMemberType) || !typeSet.isAssignable(sourceMemberType, targetMemberType)) continue;
            provisionalTargetType = provisionalTargetType.replace(targetMember.getKey(), Nullable.ifTrue((boolean)nullableTarget, (Type)sourceMemberType));
        }
        for (String mapped : this.mapAttributes.keySet()) {
            if (this.targetType.hasMember(mapped)) continue;
            problems.add(Problem.error((ProblemCode)ProblemCodes.MISSING_TARGET, (Object[])new Object[]{mapped, this.targetType.toString()}));
        }
        if (Problem.hasErrors(problems)) {
            return ResultOrProblems.failed(problems);
        }
        Struct actualTargetType = provisionalTargetType;
        List<Pair> memberList = memberMap.entrySet().stream().map(entry -> new Pair((RealizedExpression)entry.getValue(), actualTargetType.getEntry((String)entry.getKey()))).collect(Collectors.toList());
        return ResultOrProblems.of((Object)new Mapping(actualTargetType, memberList), problems);
    }

    @Generated
    public TypeProjection(Struct targetType, Map<String, Expression> mapAttributes, EnumSet<TypeCheckingOptions> options, RealizationContext realizationContext) {
        this.targetType = targetType;
        this.mapAttributes = mapAttributes;
        this.options = options;
        this.realizationContext = realizationContext;
    }

    public static enum ProblemCodes implements ProblemCode
    {
        MISSING_MEMBER,
        BAD_MAPPING,
        MISSING_TARGET;

    }

    protected static class Mapping {
        public final Struct targetType;
        public final List<Pair> memberList;

        @Generated
        public Mapping(Struct targetType, List<Pair> memberList) {
            this.targetType = targetType;
            this.memberList = memberList;
        }
    }

    protected static class Pair {
        final RealizedExpression source;
        final Struct.StructMember target;

        @Generated
        public Pair(RealizedExpression source, Struct.StructMember target) {
            this.source = source;
            this.target = target;
        }
    }

    protected class TypeProjector
    implements Projector {
        final Struct sourceType;
        final Struct producedType;
        final List<Pair> memberList;

        public Tuple apply(Tuple sourceTuple) {
            Tuple targetTuple = new Tuple(this.producedType);
            for (Pair pair : this.memberList) {
                Object sourceValue;
                try {
                    sourceValue = pair.source.evaluate((Object)sourceTuple);
                }
                catch (EvalException ex) {
                    throw new InvalidTupleException(sourceTuple, Problem.error((String)"Failed to evaluate expression '%s' against %s for attribute %s[%s]", (Object[])new Object[]{pair.source.getExpression().toSource(), sourceTuple, pair.target.getKey(), pair.target.getType()}).withChildren(new Problems[]{Problems.caught((Throwable)((Object)ex))}), ex.getCause());
                }
                try {
                    if (TypeProjection.this.options.contains((Object)TypeCheckingOptions.COERCE)) {
                        sourceValue = pair.target.getType().coerce(sourceValue);
                    }
                }
                catch (CoercionException ex) {
                    throw new InvalidTupleException(sourceTuple, String.format("Failed to coerce '%s' for %s[%s] from %s - %s", sourceValue, pair.target.getKey(), pair.target.getType(), sourceTuple, ex.getMessage()), (Throwable)ex);
                }
                targetTuple.set(pair.target, sourceValue);
            }
            return targetTuple;
        }

        public Map<List<Struct.StructMember>, List<Struct.StructMember>> getDirectMapping() {
            HashMap mappings = Maps.newHashMap();
            this.memberList.stream().forEach(pair -> {
                ResultOrProblems<StructMemberAccessExpression> sae;
                PropertyAccess pa;
                if (pair.target.getType().getUnwrappedType() instanceof SimpleType && pair.source.getExpression() instanceof PropertyAccess && !(pa = (PropertyAccess)pair.source.getExpression()).getReceiver().isPresent() && (sae = StructMemberAccessExpression.build((Type)this.sourceType, pa.getIdentifiers().stream().map(t -> t.value).collect(Collectors.toList()))).isPresent()) {
                    mappings.put(Lists.newArrayList((Object[])new Struct.StructMember[]{pair.target}), ((StructMemberAccessExpression)sae.get()).getSegments());
                }
            });
            return mappings;
        }

        @Generated
        public TypeProjector(Struct sourceType, Struct producedType, List<Pair> memberList) {
            this.sourceType = sourceType;
            this.producedType = producedType;
            this.memberList = memberList;
        }

        @Generated
        public Struct getSourceType() {
            return this.sourceType;
        }

        @Generated
        public Struct getProducedType() {
            return this.producedType;
        }
    }
}

