/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.projection;

import lombok.Generated;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.projection.Projector;
import nz.org.riskscape.engine.rl.ExpressionRealizer;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ExpressionParser;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.ExpressionProblems;
import nz.org.riskscape.rl.ast.StructDeclaration;

public class SelectProjector
implements Projector {
    private final Struct sourceType;
    private final Struct producedType;
    private final RealizedExpression expression;

    public static ResultOrProblems<? extends Projector> realize(Struct inputType, Expression selection, ExpressionRealizer expressionRealizer) {
        StructDeclaration asStruct = ExpressionParser.INSTANCE.toStruct(selection);
        ResultOrProblems realizedOr = expressionRealizer.realize((Type)inputType, (Expression)asStruct);
        if (realizedOr.hasErrors()) {
            return ResultOrProblems.failed((Problem[])new Problem[]{ExpressionProblems.get().failedToRealize(selection, (Type)inputType).withChildren(realizedOr.getProblems())});
        }
        RealizedExpression realized = (RealizedExpression)realizedOr.get();
        return ResultOrProblems.of((Object)new SelectProjector(inputType, (Struct)realized.getResultType(), realized));
    }

    public Tuple apply(Tuple t) {
        return (Tuple)this.expression.evaluate((Object)t);
    }

    public void close() {
        this.expression.close();
    }

    @Generated
    public SelectProjector(Struct sourceType, Struct producedType, RealizedExpression expression) {
        this.sourceType = sourceType;
        this.producedType = producedType;
        this.expression = expression;
    }

    @Generated
    public Struct getSourceType() {
        return this.sourceType;
    }

    @Generated
    public Struct getProducedType() {
        return this.producedType;
    }
}

