/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.projection;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.projection.Projection;
import nz.org.riskscape.engine.projection.Projector;
import nz.org.riskscape.engine.query.TupleUtils;
import nz.org.riskscape.engine.relation.SpatialMetadata;
import nz.org.riskscape.engine.types.Referenced;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeProblems;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ResultOrProblems;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public class ForceSridProjection
implements Projection {
    private final int srid;
    private final CoordinateReferenceSystem crs;
    private final GeometryFactory factory;

    public ForceSridProjection(CoordinateReferenceSystem newCrs, SRIDSet set) {
        this.srid = set.get(newCrs);
        this.crs = newCrs;
        this.factory = set.getGeometryFactory(newCrs);
    }

    public ResultOrProblems<Struct> projectType(Struct source) {
        return ResultOrProblems.of((Object)source);
    }

    public ResultOrProblems<Projector> getProjectionFunction(Struct sourceType) {
        Struct.StructMember sourceGeomMember = null;
        try {
            sourceGeomMember = TupleUtils.findRequiredGeometryMember((Struct)sourceType);
        }
        catch (RiskscapeException ex) {
            return ResultOrProblems.failed((Problem[])new Problem[]{TypeProblems.get().structMustHaveMemberType((Type)Types.GEOMETRY, sourceType)});
        }
        Type sourceGeomType = sourceGeomMember.getType().findAllowNull(Referenced.class).map(Referenced::getUnderlyingType).orElse(sourceGeomMember.getType());
        Struct projectedType = sourceType.addOrReplace(sourceGeomMember.getKey(), Referenced.ofNullable((Type)sourceGeomType, (CoordinateReferenceSystem)this.crs));
        Struct.StructMember projectedGeomMember = TupleUtils.findRequiredGeometryMember((Struct)projectedType);
        return ResultOrProblems.of((Object)new ForceSridProjector(sourceGeomMember, sourceType, projectedGeomMember, projectedType));
    }

    protected class ForceSridProjector
    implements Projector {
        private final Struct.StructMember sourceGeometryMember;
        private final Struct sourceType;
        private final Struct.StructMember projectedGeometryMember;
        private final Struct producedType;

        public Tuple apply(Tuple t) {
            Geometry geom = (Geometry)t.fetch(this.sourceGeometryMember);
            Object[] newValues = t.toArray();
            Tuple projected = Tuple.ofValues((Struct)this.producedType, (Object[])newValues);
            if (geom != null) {
                projected.set(this.projectedGeometryMember, (Object)ForceSridProjection.this.factory.createGeometry(geom));
            }
            return projected;
        }

        public Map<List<Struct.StructMember>, List<Struct.StructMember>> getDirectMapping() {
            return this.sourceType.getMembers().stream().collect(Collectors.toMap(m -> Arrays.asList(m), m -> Arrays.asList(m)));
        }

        public Optional<Function<SpatialMetadata, SpatialMetadata>> getSpatialMetadataMapper() {
            return Optional.of(spatialMetadata -> new SpatialMetadata(ForceSridProjection.this.crs, this.projectedGeometryMember));
        }

        @Generated
        public ForceSridProjector(Struct.StructMember sourceGeometryMember, Struct sourceType, Struct.StructMember projectedGeometryMember, Struct producedType) {
            this.sourceGeometryMember = sourceGeometryMember;
            this.sourceType = sourceType;
            this.projectedGeometryMember = projectedGeometryMember;
            this.producedType = producedType;
        }

        @Generated
        public Struct getSourceType() {
            return this.sourceType;
        }

        @Generated
        public Struct getProducedType() {
            return this.producedType;
        }
    }
}

