/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.projection;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.projection.Projection;
import nz.org.riskscape.engine.projection.Projector;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.problem.ResultOrProblems;

public class FlattenProjection
implements Projection {
    private final String joinCharacter;

    public FlattenProjection(String joinWith) {
        this.joinCharacter = joinWith;
    }

    public ResultOrProblems<Struct> projectType(Struct source) {
        return ResultOrProblems.of((Object)this.structFlattener((Struct)source).flattenedType);
    }

    public ResultOrProblems<Projector> getProjectionFunction(Struct sourceType) {
        return ResultOrProblems.of((Object)this.structFlattener(sourceType));
    }

    protected StructFlattener structFlattener(Struct source) {
        Struct.StructBuilder builder = new Struct.StructBuilder();
        ImmutableList stack = ImmutableList.of();
        ArrayList expressions = Lists.newArrayList();
        this.flattenVisitStruct(expressions, builder, source, (List<Struct.StructMember>)stack, this.joinCharacter, false);
        return new StructFlattener(source, builder.build(), expressions);
    }

    protected void flattenVisitStruct(List<List<Struct.StructMember>> expressions, Struct.StructBuilder copyTo, Struct struct, List<Struct.StructMember> stack, String joinWith, boolean nullable) {
        for (Struct.StructMember member : struct.getMembers()) {
            ImmutableList.Builder stackBuilder = ImmutableList.builder();
            stackBuilder.addAll(stack);
            stackBuilder.add((Object)member);
            ImmutableList newStack = stackBuilder.build();
            if (Nullable.unwrap((Type)member.getType()) instanceof Struct) {
                Struct child = (Struct)Nullable.unwrap((Type)member.getType());
                this.flattenVisitStruct(expressions, copyTo, child, (List<Struct.StructMember>)newStack, joinWith, nullable || Nullable.any((Type[])new Type[]{member.getType()}));
                continue;
            }
            expressions.add((List<Struct.StructMember>)newStack);
            String prefix = newStack.stream().map(Struct.StructMember::getKey).collect(Collectors.joining(joinWith));
            copyTo.add(prefix, Nullable.ifTrue((boolean)nullable, (Type)member.getType()));
        }
    }

    private class StructFlattener
    implements Projector {
        public final Struct sourceType;
        public final Struct flattenedType;
        public final List<List<Struct.StructMember>> expressions;

        public Struct getProducedType() {
            return this.flattenedType;
        }

        public Tuple apply(Tuple t) {
            Tuple mapped = new Tuple(this.flattenedType);
            for (int i = 0; i < this.expressions.size(); ++i) {
                List<Struct.StructMember> indices = this.expressions.get(i);
                Struct.StructMember targetEntry = (Struct.StructMember)this.flattenedType.getMembers().get(i);
                Tuple target = t;
                if (indices.size() > 0) {
                    for (Struct.StructMember entry : indices.subList(0, indices.size() - 1)) {
                        if (target == null) break;
                        target = (Tuple)target.fetch(entry);
                    }
                }
                if (target != null) {
                    Object selected = target.fetch(indices.get(indices.size() - 1));
                    mapped.set(targetEntry, selected);
                    continue;
                }
                mapped.remove(targetEntry);
            }
            return mapped;
        }

        @Generated
        public StructFlattener(Struct sourceType, Struct flattenedType, List<List<Struct.StructMember>> expressions) {
            this.sourceType = sourceType;
            this.flattenedType = flattenedType;
            this.expressions = expressions;
        }

        @Generated
        public Struct getSourceType() {
            return this.sourceType;
        }
    }
}

