/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.projection;

import lombok.Generated;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.projection.Projection;
import nz.org.riskscape.engine.projection.Projector;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeProblems;
import nz.org.riskscape.engine.types.eqrule.Coercer;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;

public class CoercerProjection
implements Projection {
    private final Struct sourceType;
    private final Struct producedType;
    private final Coercer coercer;

    public static ResultOrProblems<CoercerProjection> mapping(Struct source, Struct target, RealizationContext context) {
        return ProblemException.catching(() -> {
            Coercer sourceToTarget = (Coercer)context.getTypeSet().findEquivalenceCoercer((Type)source, (Type)target).orElseThrow(() -> new ProblemException((Problems)TypeProblems.get().couldNotCoerce((Type)source, (Type)target)));
            return new CoercerProjection(source, target, sourceToTarget);
        });
    }

    public ResultOrProblems<Projector> getProjectionFunction(Struct forSourceType) {
        assert (forSourceType == this.coercer.getSourceType());
        return ResultOrProblems.of((Object)new CoercerProjector());
    }

    @Generated
    private CoercerProjection(Struct sourceType, Struct producedType, Coercer coercer) {
        this.sourceType = sourceType;
        this.producedType = producedType;
        this.coercer = coercer;
    }

    protected class CoercerProjector
    implements Projector {
        protected CoercerProjector() {
        }

        public Struct getProducedType() {
            return CoercerProjection.this.producedType;
        }

        public Struct getSourceType() {
            return CoercerProjection.this.sourceType;
        }

        public Tuple apply(Tuple t) {
            return (Tuple)CoercerProjection.this.coercer.apply((Object)t);
        }
    }
}

