/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.plugin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.plugin.DefaultPluginDescriptor;
import nz.org.riskscape.engine.plugin.ExtensionPoint;
import nz.org.riskscape.engine.plugin.ExtensionPoints;
import nz.org.riskscape.engine.plugin.Plugin;
import nz.org.riskscape.engine.plugin.PluginClassLoader;
import nz.org.riskscape.engine.plugin.PluginDescriptor;
import nz.org.riskscape.engine.plugin.PluginRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PluginRepository.class);
    public static final PluginRepository INSTANCE = new PluginRepository();
    final List<PluginDescriptor> registeredPlugins = Lists.newArrayList();
    final List<Plugin> activatedPlugins = Lists.newArrayList();

    public static void collectFeatures(ExtensionPoints extensionPoints, List<Plugin> plugins) {
        PluginRepository dummy = new PluginRepository();
        plugins.forEach(dummy::addActivated);
        dummy.collectFeatures(extensionPoints);
    }

    public static void collectFeatures(ExtensionPoints extensionPoints, Plugin ... plugins) {
        PluginRepository.collectFeatures(extensionPoints, Arrays.asList(plugins));
    }

    PluginRepository() {
    }

    public void scanDirectory(Path directory) {
        log.info("Plugins: looking in: " + directory.toAbsolutePath().toString());
        for (File inPluginDir : directory.toFile().listFiles()) {
            if (!inPluginDir.getAbsolutePath().endsWith(".jar") && !inPluginDir.isDirectory()) continue;
            this.addPath(inPluginDir);
        }
    }

    public void addActivated(Plugin plugin) {
        this.activatedPlugins.add(plugin);
    }

    public void register(PluginDescriptor descriptor) {
        this.registeredPlugins.add(descriptor);
    }

    public void addPath(File plugin) {
        PluginDescriptor p;
        try {
            p = this.parseManifestFile(plugin);
        }
        catch (IOException | RuntimeException e) {
            log.warn("Could not register plugin from " + String.valueOf(plugin), (Throwable)e);
            return;
        }
        Optional<PluginDescriptor> existing = this.registeredPlugins.stream().filter(pd -> pd.getPluginId().equals(p.getPluginId())).findFirst();
        if (existing.isPresent()) {
            log.warn(String.format("Not registering plugin from %s, a plugin is already registered with that id: %s", plugin, existing));
        }
        this.registeredPlugins.add(p);
    }

    public List<Plugin> activateAll(Consumer<Plugin> visitor) {
        for (PluginDescriptor descriptor : this.registeredPlugins) {
            this.activatePlugin(descriptor, visitor);
        }
        return this.getActivated();
    }

    public ExtensionPoints collectFeatures(ExtensionPoints extensionPoints) {
        for (Plugin plugin : this.activatedPlugins) {
            plugin.getExtensionPoints().forEach(clz -> extensionPoints.addExtensionPoint(clz));
        }
        for (Plugin plugin : this.activatedPlugins) {
            for (Object feature : plugin.getFeatures()) {
                boolean used = extensionPoints.addFeature(feature);
                if (used) continue;
                log.error("Feature {} from plugin {} was not collected by any registered extension points", feature, (Object)plugin);
            }
        }
        log.info("Plugin features initialized");
        if (log.isDebugEnabled()) {
            log.info("Feature registration summary:");
            for (ExtensionPoint extensionPoint : extensionPoints.getAll()) {
                log.debug("  ExtensionPoint: {}", (Object)extensionPoint.getId());
                for (Object feature : extensionPoint.getFeatures()) {
                    log.debug("   - {}", feature);
                }
            }
        }
        return extensionPoints;
    }

    protected Plugin activatePlugin(PluginDescriptor descriptor, Consumer<Plugin> visitor) {
        log.info("Attempting to activate plugin {}", (Object)descriptor);
        Optional<Plugin> alreadyActivated = this.getActivatedPlugin(descriptor.getPluginId());
        if (alreadyActivated.isPresent()) {
            if (alreadyActivated.get().getDescriptor().equals(descriptor)) {
                log.info("Not activating {} - already activated", (Object)descriptor);
                return alreadyActivated.get();
            }
            throw new RiskscapeException(String.format("Plugin '%s' has already been activated from a different source : %s", descriptor, alreadyActivated.get().getDescriptor()));
        }
        if (descriptor.hasPluginDependencies()) {
            Set dependencies = descriptor.getPluginDependencies();
            for (String dependencyId : dependencies) {
                PluginDescriptor dependencyDescriptor = this.getPluginById(dependencyId).orElseThrow(() -> new PluginRuntimeException(descriptor, null, "Plugin %s depends on plugin %s, but it has not been registered", new Object[]{descriptor.getPluginId(), dependencyId}));
                log.info("Activating plugin dependency {}", (Object)dependencyDescriptor);
                this.activatePlugin(dependencyDescriptor, visitor);
                descriptor.addDependency(dependencyDescriptor);
            }
        }
        Plugin constructed = descriptor.newPluginInstance();
        visitor.accept(constructed);
        this.activatedPlugins.add(constructed);
        return constructed;
    }

    public Optional<PluginDescriptor> getPluginById(String dependencyId) {
        return this.registeredPlugins.stream().filter(pd -> pd.getPluginId().equals(dependencyId)).findAny();
    }

    private PluginDescriptor parseManifestFile(File pluginFile) throws MalformedURLException, IOException {
        URL[] dependencies;
        URL jarUrl;
        URL sourceUrl;
        if (pluginFile.isDirectory()) {
            Path pluginPath = pluginFile.toPath();
            sourceUrl = pluginPath.toUri().toURL();
            List jars = Arrays.asList(pluginFile.listFiles()).stream().filter(f -> !f.getName().equals("plugin.jar") && f.getName().endsWith(".jar")).collect(Collectors.toList());
            Path jarPath = pluginPath.resolve("plugin.jar");
            if (!jarPath.toFile().canRead()) {
                throw new PluginRuntimeException("Plugin directory '%s' does not contain a plugin.jar file ", new Object[]{pluginFile});
            }
            jarUrl = jarPath.toUri().toURL();
            dependencies = (URL[])jars.stream().map(this::fileToUrl).toArray(URL[]::new);
        } else {
            sourceUrl = jarUrl = pluginFile.toURI().toURL();
            dependencies = new URL[]{};
        }
        PluginClassLoader classLoader = new PluginClassLoader(Engine.class.getClassLoader(), jarUrl, dependencies);
        URL manifestUrl = classLoader.findResource("META-INF/MANIFEST.MF");
        if (manifestUrl == null) {
            classLoader.close();
            throw new PluginRuntimeException("Plugin from %s does not have a manifest", new Object[]{jarUrl});
        }
        Manifest manifest = new Manifest(manifestUrl.openStream());
        return new DefaultPluginDescriptor(sourceUrl, classLoader, manifest);
    }

    private URL fileToUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void finalize() throws Throwable {
        this.shutDownActivatedPlugins();
    }

    private void shutDownActivatedPlugins() throws PluginRuntimeException {
        for (Plugin plugin : this.activatedPlugins) {
            plugin.shutDown();
        }
    }

    public Optional<Plugin> getActivatedPlugin(String pluginId) {
        return this.activatedPlugins.stream().filter(pd -> pd.getId().equals(pluginId)).findAny();
    }

    public <T extends Plugin> Optional<T> getActivatedPlugin(Class<T> pluginClass) {
        return this.activatedPlugins.stream().filter(p -> p.getClass().equals(pluginClass)).map(p -> (Plugin)pluginClass.cast(p)).findFirst();
    }

    public List<Plugin> getActivated() {
        return ImmutableList.copyOf(this.activatedPlugins);
    }
}

