/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import nz.org.riskscape.engine.i18n.ResourceClassLoader;
import nz.org.riskscape.engine.plugin.DefaultPluginDescriptor;
import nz.org.riskscape.engine.plugin.PluginDescriptor;

public class PluginClassLoader
extends URLClassLoader {
    private List<PluginClassLoader> dependencies;
    private boolean frozen = false;
    private DefaultPluginDescriptor descriptor;
    private ResourceClassLoader i18nClassLoader;
    private final URL jarUrl;

    public static PluginClassLoader newDummy() {
        try {
            return new PluginClassLoader(PluginClassLoader.class.getClassLoader(), new URL("file:///"), new URL[0]);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    private static URL[] joinUrls(URL jarUrl, URL[] otherDependencies) {
        URL[] newUrls = new URL[otherDependencies.length + 1];
        newUrls[0] = jarUrl;
        System.arraycopy(otherDependencies, 0, newUrls, 1, otherDependencies.length);
        return newUrls;
    }

    public PluginClassLoader(ClassLoader engineClassLoader, URL jarUrl, URL ... dependencies) {
        super(PluginClassLoader.joinUrls(jarUrl, dependencies), engineClassLoader);
        this.jarUrl = jarUrl;
        this.dependencies = new LinkedList<PluginClassLoader>();
    }

    public void setPluginDescriptor(PluginDescriptor toSet) {
        if (this.descriptor != null) {
            throw new IllegalStateException("Can not set descriptor twice - this is effectively a final field");
        }
        if (!(toSet instanceof DefaultPluginDescriptor)) {
            throw new IllegalArgumentException("The default PluginClassLoader must be used with a DefaultPluginDescriptor");
        }
        DefaultPluginDescriptor dToSet = (DefaultPluginDescriptor)toSet;
        if (dToSet.getClassLoader() != this) {
            throw new IllegalStateException("Can not assign a descriptor that isn't assigned to this classloader itself");
        }
        this.descriptor = dToSet;
    }

    public void addDependency(PluginClassLoader classLoader) {
        if (this.frozen) {
            throw new IllegalStateException("you can't add plugin dependencies once the class loader is frozen");
        }
        this.dependencies.add(classLoader);
    }

    public void freeze() {
        this.frozen = true;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = this.findClass(name);
            }
            catch (ClassNotFoundException | SecurityException e) {
                c = this.loadClassFromEngineOrDependencies(name, resolve);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    protected synchronized Class<?> loadClassLocally(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = this.findClass(name);
            }
            catch (ClassNotFoundException e) {
                c = this.loadClassFromDependencies(name, resolve);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    private Class<?> loadClassFromEngineOrDependencies(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c;
        try {
            c = super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException e) {
            c = this.loadClassFromDependencies(name, resolve);
        }
        return c;
    }

    private Class<?> loadClassFromDependencies(String name, boolean resolve) throws ClassNotFoundException {
        for (PluginClassLoader pluginClassLoader : this.dependencies) {
            try {
                return pluginClassLoader.loadClassLocally(name, resolve);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (url == null) {
            url = super.getResource(name);
        }
        if (url == null) {
            for (PluginClassLoader pluginClassLoader : this.dependencies) {
                url = pluginClassLoader.findResource(name);
                if (url == null) continue;
                return url;
            }
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        final LinkedList<URL> collectedUrls = new LinkedList<URL>();
        this.drainEnum(this.findResources(name), collectedUrls);
        this.drainEnum(this.getParent().getResources(name), collectedUrls);
        for (PluginClassLoader pluginClassLoader : this.dependencies) {
            this.drainEnum(pluginClassLoader.findResources(name), collectedUrls);
        }
        return new Enumeration<URL>(){
            Iterator<URL> iter;
            {
                this.iter = collectedUrls.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iter.hasNext();
            }

            @Override
            public URL nextElement() {
                return this.iter.next();
            }
        };
    }

    private void drainEnum(Enumeration<URL> urlsMaybeNull, List<URL> collect) {
        if (urlsMaybeNull == null) {
            return;
        }
        while (urlsMaybeNull.hasMoreElements()) {
            collect.add(urlsMaybeNull.nextElement());
        }
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        URL url = this.getResource(name);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String toString() {
        return String.format("PluginClassLoader(%s, urls=%s, dependencies=%s)", this.descriptor.getPluginId(), this.getURLs(), this.dependencies);
    }

    public ResourceClassLoader getI18nResourceLoader() {
        if (this.i18nClassLoader == null) {
            this.i18nClassLoader = new ResourceClassLoader(this.jarUrl);
        }
        return this.i18nClassLoader;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PluginClassLoader)) {
            return false;
        }
        PluginClassLoader other = (PluginClassLoader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<PluginClassLoader> this$dependencies = this.getDependencies();
        List<PluginClassLoader> other$dependencies = other.getDependencies();
        if (this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies)) {
            return false;
        }
        URL this$jarUrl = this.getJarUrl();
        URL other$jarUrl = other.getJarUrl();
        return !(this$jarUrl == null ? other$jarUrl != null : !((Object)this$jarUrl).equals(other$jarUrl));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PluginClassLoader;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<PluginClassLoader> $dependencies = this.getDependencies();
        result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
        URL $jarUrl = this.getJarUrl();
        result = result * 59 + ($jarUrl == null ? 43 : ((Object)$jarUrl).hashCode());
        return result;
    }

    @Generated
    public List<PluginClassLoader> getDependencies() {
        return this.dependencies;
    }

    @Generated
    public URL getJarUrl() {
        return this.jarUrl;
    }
}

